%% Graphs

clear all
curdict=cd;
addpath([curdict '/glmnet_matlab'])

%% Load and cut data
filename='IP98ag.xls';
RawData2=table2array(readtable(filename));

Data=RawData2(1:end,:)';

Y=1200*(log(Data(:,2:end))-log(Data(:,1:end-1)));
t=datetime(1972,2,1)+calmonths(0:(size(Y,2)-1));
%%
fig=figure;
fig.PaperPositionMode = 'manual';
fig.PaperOrientation = 'landscape';
fig.PaperSize = [ 12  7.5 ];
fig.PaperPosition = [ 0 0 1 1];

plot(t,Y,'LineWidth',2,'Color','k')
line([t(145) t(145)],[-50 30],'Color','k','LineStyle','--')
line([t(145+144) t(145+144)],[-50 30],'Color','k','LineStyle','--')
xlim([datetime(1968,1,1) datetime(2010,12,1)])
text(t(57),-40,['\sigma =' num2str(round(sqrt(var(Y(2:145))),2))])
text(t(57+144),-40,['\sigma =' num2str(round(sqrt(var(Y(146:289))),1))])
text(t(57+288),-40,['\sigma =' num2str(round(sqrt(var(Y(290:145+288))),2))])

print('-dpdf', 'IPgrowth.pdf','-fillpage')
