function [loglikelihood, minEta]=KfoldCVsigma(res, K,delta,eta,RegSigma,invSigIni)
[N, T]=size(res);
t = floor(T/K);

for k=1:K
    clear summand2 summand resTest weirdCV relativeTo SigTest SigReg
    
    test = zeros(T,1);
    if k==K
        test(1+(k-1)*t:end) = 1; test = logical(test);
    else
        test(1+(k-1)*t:k*t) = 1; test = logical(test);
    end
    
    resTest = res(:,test)- mean(res(:,logical(1-test)),2);-mean(res(:,test),2);
    
    resTrain = res(:,logical(1-test)) - mean(res(:,logical(1-test)),2);
 
    switch RegSigma
        case 'Threshold'
            SigAssisted=(1/(size(resTrain,2)))*(resTrain*resTrain');
            for ii=1:length(eta)
                SigReg(:,:,ii) = adaptiveThresh(resTrain,SigAssisted,eta(ii),delta);
            end
        case 'GLASSO'
            deltaMatr = delta*(ones(N)-eye(N)); 
            SigReg(:,:) = GraphicalLasso(resTrain',deltaMatr);%, 0, 0, 0, 0, 0);
        case 'normalized GLASSO'

            deltaMatr = delta*(ones(N)-eye(N)); 
            SaveStd = std(resTrain');
            resTrain = SaveStd'.\resTrain;
            SigReg = GraphicalLasso(resTrain',deltaMatr);%, 0, 0, 0, 0, 0);
            SigReg = diag(SaveStd)*SigReg*diag(SaveStd);
        
        case 'adaptive normalized GLASSO'
            SigAssisted = corr(resTrain');
            invSigIni = inv(SigAssisted);
            ThetaHat =(abs(invSigIni)).^(-1);
            deltaMatr = delta*ThetaHat/mean(mean(ThetaHat));
            SaveStd = std(resTrain');
            resTrain = SaveStd'.\resTrain;
            SigReg = GraphicalLasso(resTrain',deltaMatr);%, 0, 0, 0, 0, 0);   
            SigReg = diag(SaveStd)*SigReg*diag(SaveStd);
            
        case 'adaptive GLASSO'
            SigAssisted = (1/(size(resTrain,2)))*(resTrain*resTrain');
            invSigIni = inv(SigAssisted);
%              [~, invSigIni] = GraphicalLasso(resTrain',20);
            ThetaHat =(abs(invSigIni)).^(-1);

            deltaMatr = delta*ThetaHat/mean(mean(ThetaHat));
            SigReg(:,:) = GraphicalLasso(resTrain',deltaMatr);%, 0, 0, 0, 0, 0);
            
        case 'Ledoit-Wolf'
            SigAssisted=(1/(size(resTrain,2)))*(resTrain*resTrain');
            SigReg=shrinkLedoitmanual(SigAssisted,resTrain,delta);
        case 'Sample-Cov'
            SigReg=(1/(size(resTrain,2)))*(resTrain*resTrain');
        case 'POET'
            for ii=1:10
                SigReg(:,:,ii)=POET(resTrain,ii,delta,'soft');
            end
    end
    
    for ll=1:size(SigReg,3)
        for i=1:size(resTest,2)
            summand2(i,ll) = norm(resTest(:,i)*resTest(:,i)' - SigReg(:,:,ll),'fro')^2; %/SigReg(:,:,ll)
%             summand2(i,ll) = (resTest(:,i)'/SigReg(:,:,ll)*resTest(:,i))^(1/2); 
        end
%         summandS(k,ll) = -N*T*0.5*log(2*pi) - T*0.5*log(det(SigReg(:,:,ll))) -0.5*trace(resTest'/SigReg(:,:,ll)*resTest);
    end
    %     loglikelihoodAux(k)=-sum(summand);
    %     SigTest = size(resTest,2)\(resTest*resTest'); % This one is wrong! it shold be resTest
    %     weirdCV(k) = (N^2)\norm(SigTest-SigReg,'fro')^2;
    summand2(isreal(summand2)==0) = NaN;
    summand2 = real(summand2);
    SE(k,:) = mean(summand2,1);
%     LL(k,:) = -mean(summandS,1);
end

MSE = mean(SE,1);
% MSE = mean(LL,1);
if length(MSE)>1
    [loglikelihood, minEta] = min(MSE);
    minEta = eta(minEta);
else
    loglikelihood = MSE;
    minEta = NaN;
end