
function [Ahat, Areg, Sighat, SigReg]=Regularize(X,Z,RegA,RegSigma,Fa,deltasA,N,T,RuleA,real)
    [Ahat, res, Sighat]=VARols(X,Z,T);
    switch RegA
        
        case 'OLS'
            for l=1:1
                Areg(:,:,1,l)=Ahat;
            end
            
        case 'elastic-net'
            if Fa>0
                opts=struct('nlambda',Fa,'alpha', 0.5,'intr',0,'penalty_factor',1./abs(Ahat(:)));
            else
                opts=struct('alpha', 0.5,'intr',0,'penalty_factor',1./abs(Ahat(:)));
            end
            AenetAss= glmnet(sparse(kron(Z',speye(N))), X(:),[],opts);
            
            if Fa-size(AenetAss.beta,2)>0
                AenetAss.beta(:,size(AenetAss.beta,2)+1:Fa)=repmat(AenetAss.beta(:,end),1,Fa-size(AenetAss.beta,2));
            end
            for l=1:size(AenetAss.beta,2)
                Areg(:,:,1,l)=reshape(AenetAss.beta(:,l),N,N);
            end
            if size(Areg,4)<Fa
                for l=size(Areg,4)+1:Fa
                    Areg(:,:,1,l)=ones(N,N);
                end
            end
            
        case 'LASSO'
            opts=struct('nlambda',Fa,'alpha', 1,'intr',0);
            AenetAss= glmnet(sparse(kron(Z',speye(N))), X(:),[],opts);
            if Fa-size(AenetAss.beta,2)>0
                AenetAss.beta(:,size(AenetAss.beta,2)+1:Fa)=repmat(AenetAss.beta(:,end),1,Fa-size(AenetAss.beta,2));
            end
            for l=1:size(AenetAss.beta,2)
                Areg(:,:,1,l)=reshape(AenetAss.beta(:,l),N,N);
            end
            
        case 'RIDGE'
            opts=struct('nlambda',Fa,'alpha',0,'intr',0);
            AenetAss= glmnet(sparse(kron(Z',speye(N))), X(:),[],opts);
            if Fa-size(AenetAss.beta,2)>0
                AenetAss.beta(:,size(AenetAss.beta,2)+1:Fa)=repmat(AenetAss.beta(:,end),1,Fa-size(AenetAss.beta,2));
            end
            for l=1:size(AenetAss.beta,2)
                Areg(:,:,1,l)=reshape(AenetAss.beta(:,l),N,N);
            end
            
        case 'Threshold'
            for l=1:length(deltasA)
                Areg(:,:,1,l)=adaptiveThresh([Z(:,1) X],Ahat,RuleA,deltasA(l));
            end
            
        case 'geometric'
            diffY=X-Z;
            opts=struct('nlambda',Fa,'alpha', 1,'intr',0);
            AenetAss= glmnet(sparse(kron(diffY',speye(N))), Z(:),[],opts);
            if Fa-size(AenetAss.beta,2)>0
                AenetAss.beta(:,size(AenetAss.beta,2)+1:Fa)=repmat(AenetAss.beta(:,end),1,Fa-size(AenetAss.beta,2));
            end
            for l=1:size(AenetAss.beta,2)
                Sp=-reshape(AenetAss.beta(:,l),N,N);
                if det(Sp)==0
                    Areg(:,:,1,l)=ones(size(Sp));
                else
                    Areg(:,:,1,l)= eye(size(Sp))-inv(Sp);
                end
            end
            
    end
    
    if (nargin > 9)
        for l=1:size(Areg,4)
            testnorm(l)=norm(real.A-Areg(:,:,1,l),'fro');
        end
        [~, l]=min(testnorm);
        Areg=squeeze(Areg(:,:,1,l));
    end
    
    switch RegSigma
        
        
        case 'Ledoit-Wolf'
            res(:,1)=Z(:,1);
            res(:,2:T)=X-Areg*Z;
            res=res-mean(res,2);
            SigenetAssisted=(1/(T-1))*(res*res');
            SigReg(:,:,1,1,1)=shrinkLedoit(SigenetAssisted,res);
            
        case 'Threshold'
            res(:,1)=[Z(:,1)];
            res(:,2:T)=X-Areg*Z;
            res=res-mean(res,2);
            SigenetAssisted=(1/(T-1))*(res*res');
            for f=1:length(deltasA)
                SigReg(:,:,1,1,f)=adaptiveThresh(res,SigenetAssisted,RuleA,deltasA(f));
            end
            
        case 'Sample-Cov'
            res(:,1)=Z(:,1);
            res(:,2:T)=X-Areg*Z;
            res=res-mean(res,2);
            SigReg(:,:,1,1,1)=(1/(T-1))*(res*res');
            
        case 'GLASSO'
            res(:,1)=Z(:,1);
            res(:,2:T)=X-Areg*Z;
            res=res-mean(res,2);
            for f=1:length(deltasA)  
                SigReg(:,:,1,1,f)=GraphicalLasso(res',deltasA(f));
            end
            
    end
    
end