function Simulationplot(normPlot,normPlotEnet,N,T,Model,Type,PrintPlot,vector)

h=gcf;
ax = gca;
% outerpos = ax.OuterPosition;
% ti = ax.TightInset;
% left = outerpos(1) + ti(1);
% bottom = outerpos(2) + ti(2);
% ax_width = outerpos(3) - ti(1) - ti(3);
% ax_height = outerpos(4) - ti(2) - ti(4);
% ax.Position = [left bottom ax_width ax_height];
set(h,'PaperOrientation','landscape');
set(h,'PaperUnits','normalized');


plot(vector,normPlot,'linewidth', 2); title(['N=' num2str(N) ', ' Model ' ' Type]);
legend(['T=' num2str(T)])
hold on
v=vector(end)/length(normPlotEnet):vector(end)/length(normPlotEnet):vector(end);
plot(v,normPlotEnet,'linewidth',2);
hold off
line([0 vector(end)],[1 1],'color','k','linewidth',1.5)

y=[0.5 0.15]; x=[0.75 0.85];
% annotation('textarrow',x,y,'String','Starts Thresholding Diagonal')
xlabel('\fontsize{16} \lambda'); ylabel('\fontsize{16} Frobenius Norm')

switch PrintPlot
    case 'Yes'
        namestring=['SimuPlotT'  num2str(T) 'N'  num2str(N) Type(1:11) Type(end-2) Type(end) '.pdf']; 
        print(gcf, '-dpdf', namestring)
        
        
end