% subscript to run the case for static coefficient

RW2 = RW*length(ts);
t = ts(end);

MPxAux = MPx2;
MPxAux(:,1:449) = MPx(:,1:449);
Factors = [];
for jj = 0:FactNumLags
    timeFrame = t-RW2-jj + 1:t-jj;
    Factors =[Factors;
        [ Commodity(:, timeFrame); MPxAux(:, timeFrame); TFP(:, timeFrame)]];
end

X = Y(:,t-RW2+1:t);  Z = [ones(1,size(X,2));  Factors; Y(:,t-RW2:t-1)];
switch BreakTests
    
    case 'Sigma-dynamic'
        % First estimate the coefficient static
        [Est.Ahat, Est.Areg, Est.Sighat, Est.SigReg, RegInfo(t)] =...
            RegularizeApp(X,Z,RegA,'Sample-Cov',deltas,Kfold,[],[]);
        globalAreg = Est.Areg;
        overwriteResFull(:,t-RW2+1:t) = X - Est.Areg*Z;
        globaldfA = RegInfo(t).dfA*[0;1;0]/length(ts);
        
        % Then estimate Sigma dynamic
        for t = ts
            overwriteRes = overwriteResFull(:,t-RW+1:t);
            [~, ~, ~, ~, RegInfo(t)] =...
                RegularizeApp(overwriteRes,overwriteRes,'OLS',RegSigma,deltas,Kfold,overwriteRes,globaldfA);
            minAIC(t) = min(RegInfo(t).AICcSig);
        end
        disp(['AIC for VAR static and Sigma dynamic is: ' num2str(sum(minAIC),'%1.4s.')])
        
    case 'all-static'
        [~, ~, ~, ~, RegInfo] =...
            RegularizeApp(X,Z,RegA,RegSigma,deltas,Kfold,[],[]);
        disp(['AIC for all-static is: ' num2str(min(RegInfo.AICcSig),'%1.4s.')])
        
end