% generates the decompositionTable from the connectedness tables

function decompositionTable(ts,DfinalRegIRF,DfinalRegIRFfactor,DfinalRegIRFfactorSpillovers,FinalSigmaReg,sampleVar,meanWeight)

k=0;
for t=ts
    k=k+1;
    
    % matrix selection for latex table
    Table = DfinalRegIRF(:,:,t);
    TableFact = DfinalRegIRFfactor{t};
    TableFactSpillovers = DfinalRegIRFfactorSpillovers{t};
    TableDiag =  diag(diag(Table));
    TableNoDiag = Table -diag(diag(Table));
    contTable = (FinalSigmaReg(:,:,t));
    dataReference(k) = sampleVar(k);
    
    % specify weights for right and left side multiplication
    weightComponent = (meanWeight(:,k)/sum(meanWeight(:,k)));
    weightComponent = weightComponent.^2;
    weightInnovations = ones(size(weightComponent));
    weightsFactors = ones(size(TableFact,2),1);weightInnovations;
    
    % main decompositions
    outDeg(k) =  weightComponent'*Table*weightInnovations;
    outDegOff(k) = weightComponent'*(TableNoDiag)*weightInnovations;
    outDegDiag(k) = weightComponent'*(TableDiag)*weightInnovations;
    
    outDegFactDirect(k) = weightComponent'*TableFact*weightsFactors;
    outDegFactSpillover(k) = weightComponent'*TableFactSpillovers*weightsFactors;
    outDegFact(k) = outDegFactDirect(k) + outDegFactSpillover(k);
    
    laggedCon(k) = weightComponent'*(Table - contTable)*weightInnovations;
    contempCon(k) = weightComponent'*(contTable)*weightInnovations;
    
    outDegAg(k) = outDeg(k) + outDegFact(k) ;
    
end

ExtrinsicShare = outDegOff./outDegAg;
LaggedShare = (laggedCon)./outDegAg;

% string for latex table output
TableString= ['\begin{tabular}{l l r r r r}'  ' & & {1972-1983} &  {1984-1995} & {1996-2007} & {2008-2019} \\' '\cline{3-6}' ' \midrule ' ...
    'Data variance & $v^{IP}=var(g_t)$ &' num2str(round(dataReference(1),1)) '& ' num2str(round(dataReference(2),1))  '& ' num2str(round(dataReference(3),1)) '& ' num2str(round(dataReference(4),1)) ' \\[0.2cm]' ...
    'Aggregate response & $v^{agg}=v^{f} +v^{gran} $ &' num2str(round(outDegAg(1),1)) '& ' num2str(round(outDegAg(2),1))  '& ' num2str(round(outDegAg(3),1)) '& ' num2str(round(outDegAg(4),1)) ' \\[0.2cm] ' ...
    'Factor Contributions & $v^{f}=\left.\bar{w}^{\cdot2}\right.' char(39) 'FRV \mathbf{1}$&' num2str(round(outDegFact(1),1)) '& ' num2str(round(outDegFact(2),1))  '& ' num2str(round(outDegFact(3),1)) '& ' num2str(round(outDegFact(4),1))  ' \\ ' ...
    '$\quad$  of which direct & $v^{fDir}=\left.\bar{w}^{\cdot2}\right.' char(39) 'B\Sigma_{f} B' char(39) '\mathbf{1}$ &' num2str(round(outDegFactDirect(1),1)) '& ' num2str(round(outDegFactDirect(2),1))  '& ' num2str(round(outDegFactDirect(3),1)) '& ' num2str(round(outDegFactDirect(4),1))  ' \\ ' ...
    '$\quad$  of which indirect & $v^{fInd}=v^{f}-v^{fDir}$ &' num2str(round(outDegFactSpillover(1),1)) '& ' num2str(round(outDegFactSpillover(2),1))  '& ' num2str(round(outDegFactSpillover(3),1)) '& ' num2str(round(outDegFactSpillover(4),1))  ' \\[0.2cm] ' ...
    'Granular Contributions & $v^{gran}=\left.\bar{w}^{\cdot2}\right.' char(39) 'IRV \mathbf{1}$ &' num2str(round(outDeg(1),1)) '& ' num2str(round(outDeg(2),1))  '& ' num2str(round(outDeg(3),1)) '& ' num2str(round(outDeg(4),1)) ' \\ ' ...%  'Innovation Variance & $v^{inn}=w' char(39) 'diag(FEV)w$ & ' num2str(round(InnovDiag(1),1)) '& ' num2str(round(InnovDiag(2),1))  '& ' num2str(round(InnovDiag(3),1)) ' \\[0.4cm] '...   '$\quad$  of which  Contemporaenous  & $v^{Cont}=w' char(39) '3*\Sigma_uw$ & ' num2str(round(contCon(1),1)) '& ' num2str(round(contCon(2),1))  '& ' num2str(round(contCon(3),3)) ' \\' ... '$\quad$  of which  Lagged & $v^{lagged}=v^{agg}-v^{Cont}$ &  ' num2str(round(laggedCon(1),1)) '& ' num2str(round(laggedCon(2),1))  '& ' num2str(round(laggedCon(3),1)) ' \\[0.4cm] '...
    '$\quad$  of which intrinsic &$v^{IC}=\left.\bar{w}^{\cdot2}\right.' char(39) 'diag(IRV)\mathbf{1}$ &  ' num2str(round(outDegDiag(1),1)) '& ' num2str(round(outDegDiag(2),1))  '& ' num2str(round(outDegDiag(3),1))  '& ' num2str(round(outDegDiag(4),1))  ' \\'...
    '$\quad$  of which extrinsic & $v^{EC}=v^{gran}-v^{IC}$ & ' num2str(round(outDegOff(1),1)) '& ' num2str(round(outDegOff(2),1))  '& ' num2str(round(outDegOff(3),1))  '& ' num2str(round(outDegOff(4),1)) '\\'...
    '$\quad$  of which contemp.  & $v^{cont.}=\left.\bar{w}^{\cdot2}\right.' char(39) '\Sigma \mathbf{1}$& ' num2str(round(contempCon(1),1)) '& ' num2str(round(contempCon(2),1))  '& ' num2str(round(contempCon(3),1))  '& ' num2str(round(contempCon(4),1))  ' \\' ...
    '$\quad$  of which lagged  &$v^{lag}= v^{gran}-v^{cont.}$ &  ' num2str(round(laggedCon(1),1)) '& ' num2str(round(laggedCon(2),1))  '& ' num2str(round(laggedCon(3),1)) '& ' num2str(round(laggedCon(4),1))  ' \\[0.2cm]'...
    'Extrinsic Share & $ v^{EC}/v^{agg}$& '  num2str(round(ExtrinsicShare(1),2)) '& ' num2str(round(ExtrinsicShare(2),2))  '& ' num2str(round(ExtrinsicShare(3),2)) '& ' num2str(round(ExtrinsicShare(4),2))  ' \\ '...
    'Lagged Share & $ v^{lag}/v^{agg}$& '  num2str(round(LaggedShare(1),2)) '& ' num2str(round(LaggedShare(2),2))  '& ' num2str(round(LaggedShare(3),2)) '& ' num2str(round(LaggedShare(4),2)) ' \\ \bottomrule \end{tabular}'];
disp(TableString)

end