% Intermediate function to estiamte A for regularisiations on the
% coefficient matrix
%
%Inputs
%   Y: A 3D matrix of dimensions Na x Ta x R.
%   F: A vector of length Na containing some values.
%   Regularization: A structure containing two fields A and Sigma.
%   deltas: A delta hyperparameters in a vector of length Na.
%   realCof: structure with true parameters.
%   target: String for FEVD target.
%   H: A scalar value for the horizon of the FEVD.
%Outputs
%   oraclenorm: A vector of length R.
%   oracleNormStruct: A structure of length R.
%Functionality
%   The function computes the two outputs oraclenorm and oracleNormStruct
%   for R realizations of the input matrix Y. The oracle norms are the main
%   output for the simulation table
%   The computation is done in parallel using a parfor loop.
%
% Author: Ruben Hipp, 2021

function [oraclenorm, oracleNormStruct] = estimationA(Y,F,Regularization,deltas,realCof,target,H)
[Na,Ta,R]=size(Y);
RegA1=Regularization.A;
RegSigma1=Regularization.Sigma;

parfor r=1:R
    Xa=Y(:,2:end,r);
    Za=Y(:,1:end-1,r);
    [oraclenorm(r), oracleNormStruct(r)] = parforloop(Xa,Za,RegA1,RegSigma1,F,deltas,Na,Ta,realCof,target,H);
end

end