%% Evaluate the FEVD according to some metrics
% Input 
%       -D: A structure containing 
%           .Reg: regularized network matrix
%           .estimated: unregularized network matrix
%           .real: the true network matrix
%           .Struct: the structural network matrix
%
% Output:
%       norms: a structure containing different metric to evaluate the
%       goodness of fit.
function norms = evaluate(D)

Dreg = D.Reg;
Dhat = D.estimated;
Dreal = D.real;
DStruct = D.Struct;

[N,~,R,K,F]=size(Dreg);

for r=1:R
    clear A Astruct
    A = Dhat(:,:,r)-Dreal;
    frobHone(r,1)=norm(Dhat(:,:,r)-ones(N),'fro');
    frobH(r,1)=norm(A,'fro');
    meanH(r,1)=mean(mean(A));

    Astruct = Dhat(:,:,r)-DStruct;
    frobHstruct(r,1) = norm(Astruct,'fro');
    meanHstruct(r,1)=mean(mean(Astruct));

    
    for k=1:K
        for f=1:F
            clear A Astruct
            A = Dreg(:,:,r,k,f)-Dreal;
            Astruct = Dreg(:,:,r)-DStruct;

            frobRegone(r,k,f)=norm(Dreg(:,:,r,k,f)-ones(N),'fro');
            frobReg(r,k,f)=norm(A,'fro');
            meanReg(r,k,f)=mean(mean(A));
            relNorm(r,k,f)=frobReg(r,k,f)/frobH(r);
            
            frobRegStruct(r,k,f)=norm(Astruct,'fro');
            meanRegStruct(r,k,f)=mean(mean(Astruct));
            relNormStruct(r,k,f)=frobRegStruct(r,k,f)/frobHstruct(r);
            
            
        end
    end
end

norms = struct('frobH',frobH,'frobHone',frobHone,'frobReg',frobReg,'frobRegone',frobRegone,...
    'meanH',meanH,'meanReg',meanReg,'relNorm',relNorm,'relNormStruct',relNormStruct,...
    'frobRegStruct',frobRegStruct,'frobHstruct',frobHstruct,'meanRegStruct',meanRegStruct,'meanHstruct',meanHstruct);
end