% Produces the latex table with AIC values.
% Different formats can be found in the comments at the end.

function OutputTable = latexTableAIC(MSE,LL,AICcCoef,AICcSig,ts)


OLS(1,1:4) = 100;                           OLS(2,1:4) = inf;
ENET(1,:) = 100*squeeze(min(MSE(:,3,ts)));  ENET(2,:) = 0.00001*AICcCoef(3,ts);
ANETOLS(1,:) = 100*squeeze(min(MSE(:,1,ts)));   ANETOLS(2,:) = 0.00001*AICcCoef(1,ts);
AENETENET(1,:) = 100*squeeze(min(MSE(:,2,ts))); AENETENET(2,:) = 0.00001*AICcCoef(2,ts);
SampleCov(1,:) = 100*ones(1,length(ts));        SampleCov(2,:) = 0.00001*AICcSig(4,ts);
GLASSO(1,:) = 100*squeeze(min(LL(:,2,ts)));     GLASSO(2,:) = 0.00001*AICcSig(2,ts);
LW(1,:) = 100*squeeze(min(LL(:,3,ts)));         LW(2,:) = 0.00001*AICcSig(3,ts);
Thresh(1,:) = 100*squeeze(min(LL(:,1,ts)));     Thresh(2,:) = 0.00001*AICcSig(1,ts);


OutputTable = ['\begin{tabular}{@{\extracolsep{0pt}} l  R{1.55cm} R{1.55cm} R{1.55cm} R{1.55cm} R{1.7cm}}' ...
' &  \multicolumn{4}{c}{MSE}  & \multicolumn{1}{c}{AIC} \\  \cline{2-5} \cline{6-6} & & & & \\[-0.3cm] '...
' &  {1972-1983} &  {1984-1995} &  {1996-2007} &  {2008-2019}& {1972-2019} \\  \midrule   '...
'\multicolumn{5}{l}{\textit{Panel A: Model selection for regression}}\\'...
    '$\quad$ OLS  & ' num2str(round(OLS(1,1),2)) '\% & '  num2str(round(OLS(1,2),2)) '\% & ' num2str(round(OLS(1,3),2)) '\% & ' num2str(round(OLS(1,4),2)) '\% & ' num2str(round(sum(OLS(2,:)),3)) '\\' ...
    '$\quad$ Elastic Net  & ' num2str(round(ENET(1,1),2)) '\% & ' num2str(round(ENET(1,2),2)) '\% & ' num2str(round(ENET(1,3),2)) '\% & ' num2str(round(ENET(1,4),2)) '\% & ' num2str(round(sum(ENET(2,:)),3)) '\\' ... 
    '$\quad$ Adaptive Elastic Net (OLS init.)  &' num2str(round(ANETOLS(1,1),2)) '\% & ' num2str(round(ANETOLS(1,2),2)) '\% & ' num2str(round(ANETOLS(1,3),2))...
    '\% & ' num2str(round(ANETOLS(1,4),2))  '\% & ' num2str(round(sum(ANETOLS(2,:)),3)) '\\' ... 
    '$\quad$ Adaptive Elastic Net (ENet init.)  & ' num2str(round(AENETENET(1,1),2)) '\% & ' num2str(round(AENETENET(1,2),2)) '\% & ' num2str(round(AENETENET(1,3),2))...
    '\% & ' num2str(round(AENETENET(1,4),2)) '\% & ' num2str(round(sum(AENETENET(2,:)),3)) '\\[0.4cm]' ...
    '\multicolumn{5}{l}{\textit{Panel B: Model selection for covariance matrix}}\\ ' ...
    ' $\quad$ Sample Covariance  & ' num2str(round(SampleCov(1,1),2)) '\% & ' num2str(round(SampleCov(1,2),2)) '\% & ' num2str(round(SampleCov(1,3),2)) ...
    '\% & ' num2str(round(SampleCov(1,4),2)) '\%  & ' num2str(round(sum(SampleCov(2,:)),3)) '\\' ...
    '$\quad$ GLASSO & ' num2str(round(GLASSO(1,1),2)) '\% & ' num2str(round(GLASSO(1,2),2)) '\% & ' num2str(round(GLASSO(1,3),2)) '\% & ' num2str(round(GLASSO(1,4),2)) '\% & ' num2str(round(sum(GLASSO(2,:)),3)) '\\' ...
    '$\quad$ Ledoit-Wolf  & ' num2str(round(LW(1,1),2)) '\% & ' num2str(round(LW(1,2),2)) '\% & ' num2str(round(LW(1,3),2)) '\% & ' num2str(round(LW(1,4),2)) '\% & ' num2str(round(sum(LW(2,:)),3)) '\\' ...
    ' $\quad$ Adaptive Threshold  & ' num2str(round(Thresh(1,1),2)) '\% & ' num2str(round(Thresh(1,2),2)) '\% & ' num2str(round(Thresh(1,3),2)) '\% & ' num2str(round(Thresh(1,4),2))  '\% & ' num2str(round(sum(Thresh(2,:)),3)) '\\' ...
    '\bottomrule  \end{tabular}'];

disp(OutputTable);
end

%% OTHER FORMATS


% OutputTable = ['\begin{tabular}{@{\extracolsep{4pt}} l  R{1.2cm}R{0.75cm} R{1.2cm}R{0.75cm} R{1.2cm}R{0.75cm}}& &' ...
%     '\multicolumn{3}{c}{{MSE }} &  \multicolumn{3}{c}{{AIC}} \\' ...
%     '\cline{2-4}\cline{5-7} & & & & & & & \\[-0.3cm]' ...
%     '&  1972-1983 & 1984-1995 &  1996-2007 & 1972-1983 & 1984-1995 & 1996-2007 \\ \midrule     \textit{Panel A: Model selection for regression}\\'...
%     'OLS  & ' num2str(round(OLS(1,1),2)) '\% & '   num2str(round(OLS(1,2),2)) '\% & ' num2str(round(OLS(1,3),2)) '\% & ' num2str(round(OLS(2,1),3))  ' & ' num2str(round(OLS(2,2),3)) ' & '  num2str(round(OLS(2,3),3)) '\\' ...
%     'Elastic Net  & ' num2str(round(ENET(1,1),2)) '\% & '  num2str(round(ENET(1,2),2)) '\% & ' num2str(round(ENET(1,3),2)) '\% & '  num2str(round(ENET(2,1),3))  ' & '  num2str(round(ENET(2,2),3)) ' & ' num2str(round(ENET(2,3),3)) '\\' ... 
%     'Adaptive Elastic Net (OLS initalization)  &' num2str(round(ANETOLS(1,1),2)) '\% & ' num2str(round(ANETOLS(1,2),2)) '\% & ' num2str(round(ANETOLS(1,3),2)) '\% & '  num2str(round(ANETOLS(2,1),3))  ' & '  num2str(round(ANETOLS(2,2),3)) ' & '  num2str(round(ANETOLS(2,3),3)) '\\' ... 
%     'Adaptive Elastic Net (ENet initalization)  & ' num2str(round(AENETENET(1,1),2)) '\% & ' num2str(round(AENETENET(1,2),2)) '\% & ' num2str(round(AENETENET(1,3),2)) '\% & '  num2str(round(AENETENET(2,1),3))  ' & ' num2str(round(AENETENET(2,2),3)) ' & '  num2str(round(AENETENET(2,3),3)) '\\[0.4cm]' ...
%     '\textit{Panel B: Model selection for covariance matrix}\\ ' ...
%     'Sample Covariance  & ' num2str(round(SampleCov(1,1),2)) '\% & '  num2str(round(SampleCov(1,2),2)) '\% & ' num2str(round(SampleCov(1,3),2)) '\% & '  num2str(round(SampleCov(2,1),3))  ' & '  num2str(round(SampleCov(2,2),3)) ' & ' num2str(round(SampleCov(2,3),3)) '\\' ...
%     'GLASSO & ' num2str(round(GLASSO(1,1),2)) '\% & '  num2str(round(GLASSO(1,2),2)) '\% & ' num2str(round(GLASSO(1,3),2)) '\% & '  num2str(round(GLASSO(2,1),3))  ' & ' num2str(round(GLASSO(2,2),3)) ' & ' num2str(round(GLASSO(2,3),3)) '\\' ...
%     'Ledoit-Wolf  & ' num2str(round(LW(1,1),2)) '\% & ' num2str(round(LW(1,2),2)) '\% & '  num2str(round(LW(1,3),2)) '\% & '  num2str(round(LW(2,1),3))  ' & '   num2str(round(LW(2,2),3)) ' & ' num2str(round(LW(2,3),3)) '\\' ...
%     'Adaptive Threshold  & ' num2str(round(Thresh(1,1),2)) '\% & '  num2str(round(Thresh(1,2),2)) '\% & ' num2str(round(Thresh(1,3),2)) '\% & ' num2str(round(Thresh(2,1),3))  ' & '  num2str(round(Thresh(2,2),3)) ' & '  num2str(round(Thresh(2,3),3)) '\\' ...
%     '\bottomrule  \end{tabular}'];
% 
% 

% OutputTable = ['\begin{tabular}{@{\extracolsep{2pt}} l  R{1.2cm}R{0.75cm} R{1.2cm}R{0.75cm} R{1.2cm}R{0.75cm}}&  ' ...
%     '\multicolumn{2}{c}{{1972-1983}} &  \multicolumn{2}{c}{{1984-1995}} &  \multicolumn{2}{c}{{1996-2007}} \\' ...
%     '\cline{2-3}\cline{4-5}\cline{6-7} & & & & & & \\[-0.3cm]' ...
%     '&  MSE & AIC &  MSE & AIC & MSE & AIC \\ \midrule     \multicolumn{7}{l}{\textit{Panel A: Model selection for regression}}\\'...
%     '$\quad$ OLS  & ' num2str(round(OLS(1,1),2)) '\% & ' num2str(round(OLS(2,1),3))  ' & '  num2str(round(OLS(1,2),2)) '\% & ' num2str(round(OLS(2,2),3)) ' & ' num2str(round(OLS(1,3),2)) '\% & ' num2str(round(OLS(2,3),3)) '\\' ...
%     '$\quad$ Elastic Net  & ' num2str(round(ENET(1,1),2)) '\% & ' num2str(round(ENET(2,1),3))  ' & '  num2str(round(ENET(1,2),2)) '\% & ' num2str(round(ENET(2,2),3)) ' & ' num2str(round(ENET(1,3),2)) '\% & ' num2str(round(ENET(2,3),3)) '\\' ... 
%     '$\quad$ Adaptive Elastic Net (OLS initalization)  &' num2str(round(ANETOLS(1,1),2)) '\% & ' num2str(round(ANETOLS(2,1),3))  ' & '  num2str(round(ANETOLS(1,2),2)) '\% & ' num2str(round(ANETOLS(2,2),3)) ' & ' num2str(round(ANETOLS(1,3),2)) '\% & ' num2str(round(ANETOLS(2,3),3)) '\\' ... 
%     '$\quad$ Adaptive Elastic Net (ENet initalization)  & ' num2str(round(AENETENET(1,1),2)) '\% & ' num2str(round(AENETENET(2,1),3))  ' & '  num2str(round(AENETENET(1,2),2)) '\% & ' num2str(round(AENETENET(2,2),3)) ' & ' num2str(round(AENETENET(1,3),2)) '\% & ' num2str(round(AENETENET(2,3),3)) '\\[0.4cm]' ...
%     '\multicolumn{7}{l}{\textit{Panel B: Model selection for covariance matrix}}\\ ' ...
%     ' $\quad$ Sample Covariance  & ' num2str(round(SampleCov(1,1),2)) '\% & ' num2str(round(SampleCov(2,1),3))  ' & '  num2str(round(SampleCov(1,2),2)) '\% & ' num2str(round(SampleCov(2,2),3)) ' & ' num2str(round(SampleCov(1,3),2)) '\%  & ' num2str(round(SampleCov(2,3),3)) '\\' ...
%     '$\quad$ GLASSO & ' num2str(round(GLASSO(1,1),2)) '\% & ' num2str(round(GLASSO(2,1),3))  ' & '  num2str(round(GLASSO(1,2),2)) '\% & ' num2str(round(GLASSO(2,2),3)) ' & ' num2str(round(GLASSO(1,3),2)) '\% & ' num2str(round(GLASSO(2,3),3)) '\\' ...
%     '$\quad$ Ledoit-Wolf  & ' num2str(round(LW(1,1),2)) '\% & ' num2str(round(LW(2,1),3))  ' & '  num2str(round(LW(1,2),2)) '\% & ' num2str(round(LW(2,2),3)) ' & ' num2str(round(LW(1,3),2)) '\% & ' num2str(round(LW(2,3),3)) '\\' ...
%     ' $\quad$ Adaptive Threshold  & ' num2str(round(Thresh(1,1),2)) '\% & ' num2str(round(Thresh(2,1),3))  ' & '  num2str(round(Thresh(1,2),2)) '\% & ' num2str(round(Thresh(2,2),3)) ' & ' num2str(round(Thresh(1,3),2)) '\% & ' num2str(round(Thresh(2,3),3)) '\\' ...
%     '\bottomrule  \end{tabular}'];

