function latexTableEstimationOverview(Level,N,AvCon,dfA,dfSig,LW,R2fact,R2spill)


if Level == 2
    numberString = 'Two';
elseif Level == 3
    numberString = 'Three';
elseif Level == 4
    numberString = 'Four';
elseif Level == 5
    numberString = 'Five';
elseif Level == 6
    numberString = 'Six';
end


levelString = ['\textit{' numberString '-digit (' num2str(N) ' sectors) }'];

[avCon01, df01,df02, LW01, R2fact01, R2spill01] = deal([]);

for ii = 1:2
    for jj = 1:4
        avCon01 = [avCon01 ' &  ' num2str(round(AvCon(ii,jj),1)) '\% '];
        df01 = [df01 ' &  ' num2str(round(dfA(ii,jj),1))];
        df02 = [df02 ' &  ' num2str(round(dfSig(ii,jj),1))];
        LW01 = [LW01 ' &  ' num2str(round(LW(ii,jj),1))];
        R2fact01 = [R2fact01 ' &  ' num2str(round(R2fact(ii,jj),1)) '\% ' ];
        R2spill01 = [R2spill01 ' &  ' num2str(round(R2spill(ii,jj),1)) '\%   '];
    end
end

tableOutput = [ levelString '\\'...
    '$\quad$ $C(D^{gH})$   ' avCon01 ' \\'...
    '$\quad$ $df(A)$  ' df01 '   \\'...
    '$\quad$ $df(\Sigma)$  ' df02 '   \\'...
    '$\quad$ LW test (p-value)  ' LW01 '   \\'...
    '$\quad$ Partial $R^2$ (Factors)  ' R2fact01 ' \\'...
    '$\quad$ Partial $R^2$ (Spillovers)  ' R2spill01 '\\[0.4cm]'];
disp(tableOutput)
end
