function latex_table=makeConnectednessTable(Connect,Names)
N=size(Connect,1);
M=Connect*100;
MnD=M-diag(diag(M));

beginning=['\begin{adjustbox}{angle=90} \begin{tabular}{l||' repmat('r',[1,size(Connect,2)]) '|r}'];
ending='\end{tabular}\end{adjustbox}';


Firstline='\backslashbox{To}{From}&';
for n=1:N+1
    if n<=N
        Firstline=[Firstline '\rotatebox{270}{' Names(n,:) '} &'];
    else
        Firstline=[Firstline '\rotatebox{270}{From-Con} \\'];
    end
end

for n=1:N+1
    clear Content
    if n<=N
        
        for t=1:N+1
            if t==1
                Content=[Names(n,:) '&' num2str(M(n,t)) ' &'];
            elseif t<N+1 && t>1
                Content=[Content num2str(M(n,t)) ' &'];
            else
                Content=[Content num2str(sum(MnD(n,:))) ' \\'];
            end
        end
        
    else
        
        for t=1:N+1
            if t==1
                Content=[ ' \hline To Con &' num2str(sum(MnD(:,t))) ' &'];
            elseif t<N+1 && t>1
                Content=[Content num2str(sum(MnD(:,t))) ' &'];
            else
                Content=[Content num2str(round(mean(sum(MnD)))) ' \\'];
            end
        end
        
    end
    
    if n==1
        ContentFinal=Content;
    else
        ContentFinal=[ContentFinal Content];
    end
end



doubleLine='\hline \hline ';


latex_table = [beginning Firstline doubleLine ContentFinal ending];