function latex_table=makeLatexTable(relOracle,N,T,isMin)

M=relOracle*100;

beginning=['\begin{tabular}{l||' repmat('r',[1,size(relOracle,2)]) '}'];
ending='\end{tabular}';


Firstline='$N\backslash T$&';
for t=1:length(T)
    if t<length(T)
        Firstline=[Firstline num2str(T(t)) '&'];
    else
        Firstline=[Firstline num2str(T(t)) '\\'];
    end
end

for n=1:length(N)
    clear Content
    Content=[num2str(N(n)) '&'];
    for t=1:length(T)
        if t<length(T)
            if M(n,t)==0
                Content=[Content  ' &'];
            else
                if isMin(n,t)==1
                    Content=[Content '\textbf{' num2str(M(n,t)) '\%} &'];
                    
                else
                    Content=[Content num2str(M(n,t)) '\% &'];
                end
            end
        else
            if M(n,t)==0
                Content=[Content  ' \\'];
            else
                if isMin(n,t)==1
                    Content=[Content '\textbf{' num2str(M(n,t)) '\%} \\'];
                    
                else
                    Content=[Content num2str(M(n,t)) '\% \\'];
                end
            end
        end
    end
    if n==1
        ContentFinal=Content;
    else
        ContentFinal=[ContentFinal Content];
    end
end



doubleLine='\hline \hline';


latex_table = [beginning Firstline doubleLine ContentFinal ending];






