function networkPlot(DfinalReg,meanWeight,names,ts)

N = size(DfinalReg,1);


TITLE={'1972 to 1983','1984 to 1995','1996 to 2007','2008 to 2019'};
fig=figure('Name','Network plot');
fig.PaperPositionMode = 'manual';
fig.PaperOrientation = 'landscape';
fig.PaperSize = [ 10  6];
fig.PaperPosition = [ 0 0 10 6]; 
tlo = tiledlayout(2,round(length(ts)/2), 'Padding', 'compact', 'TileSpacing', 'none');
k=0;
for t=ts
    k=k+1;
    weightComponent = N*meanWeight(:,k)/sum(meanWeight(:,k));
    Table=(DfinalReg(:,:,t)-diag(diag(DfinalReg(:,:,t))));
    avConnectednessReg(t) = sum(mean(Table));
    outCon = sum(Table,1)+eps;% 
    nodeSize = (weightComponent).^(2/3); sum(Table,2)+eps;
    Table(Table<quantile(Table(:),0.95)) = 0;
    
    G = digraph(Table,'omitselfloops');
    
    [~,ranking] = sort(outCon,'descend');                  % rank by in-nodeSizerees
    
    subfig(k) = nexttile(tlo);
    if k == 1
        xlimSave=subfig(k).XLim;
        ylimSave=subfig(k).YLim;
    else
        subfig(k).XLim = xlimSave;
        subfig(k).YLim = ylimSave;
    end
    [~,ranks]=sort(table2array(G.Edges(:,2)),'ascend');
    EdgeC = repmat((0:(1/length(ranks)):1),3,1)';
    EdgeC = EdgeC(ranks,:);
    %colormap cool
    H = plot(G,'MarkerSize',(nodeSize)*30/max(nodeSize),...   % log scale node size by in-nodeSizeree
        'Layout','force', ...                               arrange by force layout
        'NodeCData',outCon, ...                            % color by in-nodeSizeree
        'EdgeColor',EdgeC,...%  'Layout','force',...
        'EdgeAlpha', 0.05);
    
    for i=1:length(outCon)
        if i<=1
            top = names(ranking(i)); top=char(string(top)); 
            labelnode(H,ranking(i),top);
            
        else

            labelnode(H,ranking(i),'');
        end
    end
    H.NodeFontSize=12;
    H.NodeFontAngle='italic';
    caxis([0 1])
    box off
    axis off

    title([TITLE{k} ', C(D^{gH})=' num2str(round(avConnectednessReg(t),2))],'FontSize',12 )
end
set(subfig,'Colormap',parula)
outterPlot = axes(fig,'visible','off');
c = colorbar(outterPlot,'Location','westoutside','FontSize',12 );

c.Label.String = 'Out-connectedness';
c.AxisLocation = 'out';
c.Box = 'off';
c.FontSize = 10;
c.Position(3) = c.Position(3)*0.25;
c.Position(1) = c.Position(1)*0.35;

end