% parforloop functions for A-reg simulation
%
%Inputs
%   Xa: Dependent variable matrix of dimensions Na x Ta-1.
%   Za: Independent variable matrix of dimensions Na x Ta-1.
%   RegA1: string with the regularization target for the coef.
%   RegSigma1: A string with the regularization cov target.
%   F: A vector of length Na containing some values.
%   deltas: A vector of length Na.
%   Na: A scalar value representing the number of agents.
%   Ta: A scalar value representing the number of time steps.
%   realCof: structure with true parameters.
%   target: String for FEVD target.
%   H: A scalar value for the horizon of the FEVD.
%
%Outputs
%   oraclenorm: A scalar containing the oracle norm to the real FEVD.
%   oraclenormStruct: A structure containg additional information on the
%   norms.
%Functionality
%   The function performs the regularisation of the coefficent matrix and
%   returns the oracle norm to the real FEVD. 
%
% Author: Ruben Hipp, 2021
function [oraclenorm, oraclenormStruct] = parforloop(Xa,Za,RegA1,RegSigma1,F,deltas,Na,Ta,realCof,target,H)

% regularize coefficent A first
[Est.Ahat, Est.Areg, Est.Sighat, Est.SigReg] = RegularizeA(Xa,Za,RegA1,RegSigma1,F,deltas,Na,Ta);

% calculate the estimated and real forecast error variance decompositions for "target"
D = FEVD(Est,realCof,H,target);

%  evalute the performance of the regressions
norms = evaluate(D);
normPlotReg = norms.relNorm;

minReg = min(min(normPlotReg))==normPlotReg;

oraclenorm = unique(normPlotReg(minReg));

normPlotRegStruct = norms.relNormStruct;

minRegStruct = min(min(normPlotRegStruct))==normPlotRegStruct;

oraclenormStruct = unique(normPlotRegStruct(minRegStruct));
end