function betas=regCV(Xinput,N)

for ii=1:N
    clear minMSEx MSE
    selection=logical(zeros(N,1));
    selection(ii)=1;
    X=Xinput(selection,:);
    Z=[ones(1,size(X,2)); Xinput(logical(1-selection),:)];
    Kfold=10;
    nLambdas=100;
    
    opts=struct('alpha', 0.5,'intr',0,'nlambda',nLambdas);
    cvObj= cvglmnet(Z', X(:),[],opts,[],3,[],1);
    func=@(x)KfoldCV(X,Z, Kfold,x,'doesntmatter','enet');
    
    parfor i=1:length(cvObj.lambda)
        MSE(i)=func(cvObj.lambda(i));
    end
    [~,minMSEx]=min(MSE);lambdaMin=cvObj.lambda(minMSEx);
    opts=struct('alpha', 0.5,'intr',0,'lambda',lambdaMin);
    fit= glmnet(Z', X(:),[],opts);
    alpha=0.5;
    
    AIni=fit.beta;
    
    weights=abs(AIni(:)+10e-8).^(-1);
    opts=struct('alpha', alpha,'intr',0,'penalty_factor',weights,'lambda',lambdaMin);
    
    cvObj= glmnet(Z', X(:),[],opts);
    betas(:,ii)=cvObj.beta;
     
end

