function x=mult_var_gauss(p,Sigma,correlations)
% 	p number of patterns
%	n number of variables
% 	Sigma covariance matrix
%	x is n times p data with mean zero and cov Sigma
%
% Copyright (C) 2011-, Vicenç Gomez, Bert Kappen
% Last modified: Nov 1, 2013 Vicenç Gomez

n=size(Sigma,1);

if correlations,
	[v d] = eig(Sigma);
	y=randn(n,p);
	x=v*sqrt(d)*y;
else
	x=randn(n,p);
end;
x=x-mean(x,2)*ones(1,p);
klad=sum(x.^2,2)/p;
x=x./(sqrt(klad)*ones(1,p));
