function [residual, g1, g2, g3] = fv_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(9, 1);
XSS__ = params(4)/(params(4)-1);
pss__ = params(9);
psss__ = ((1-params(2)*pss__^(params(4)-1))/(1-params(2)))^(1/(1-params(4)));
vss__ = (1-params(2))*psss__^(-params(4))/(1-params(2)*pss__^params(4));
icsss__ = psss__/(1-pss__^(params(4)-1)*params(2)*params(1))/(1-params(3));
PSI__ = icsss__*(1-pss__^params(4)*params(2)*params(1))/(XSS__*vss__^params(5));
YSS__ = (icsss__*(1-pss__^params(4)*params(2)*params(1))/(vss__^params(5)*XSS__*PSI__))^(1/(1+params(5)));
T63 = y(14)^(-1);
T73 = params(4)/(params(4)-1)*PSI__*y(12)^params(5);
T77 = (y(13)/y(5))^(1+params(5));
T80 = y(16)^params(4);
T90 = y(16)^(params(4)-1);
T92 = T90/y(17);
T107 = params(9)/params(1)*(y(8)/params(9))^params(6);
T111 = (y(13)/YSS__)^params(7);
T125 = params(2)*y(8)^params(4);
residual(1) = y(6)^(-1)-params(1)*y(11)*y(10)*T63/y(16);
residual(2) = y(7)-(T73*T77+params(2)*params(1)*y(11)*T80*y(15));
residual(3) = y(7)/y(9)-(y(13)/y(6)+params(2)*params(1)*y(11)*y(15)*T92);
residual(4) = y(10)-(params(8)*y(2)+(1-params(8))*T107*T111);
residual(5) = 1-(params(2)*y(8)^(params(4)-1)+(1-params(2))*y(9)^(1-params(4)));
residual(6) = y(12)-(T125*y(4)+(1-params(2))*y(9)^(-params(4)));
residual(7) = y(13)-(y(6)+params(3)*y(13));
lhs =log(y(11));
rhs =params(12)*log(y(3))+x(it_, 2);
residual(8)= lhs-rhs;
lhs =log(y(5));
rhs =params(11)*log(y(1))+x(it_, 1);
residual(9)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(9, 19);

  %
  % Jacobian matrix
  %

T159 = getPowerDeriv(y(13)/y(5),1+params(5),1);
  g1(1,6)=getPowerDeriv(y(6),(-1),1);
  g1(1,14)=(-(params(1)*y(11)*y(10)*getPowerDeriv(y(14),(-1),1)/y(16)));
  g1(1,16)=(-(params(1)*y(11)*y(10)*(-T63)/(y(16)*y(16))));
  g1(1,10)=(-(params(1)*y(11)*T63/y(16)));
  g1(1,11)=(-(T63/y(16)*params(1)*y(10)));
  g1(2,5)=(-(T73*(-y(13))/(y(5)*y(5))*T159));
  g1(2,7)=1;
  g1(2,15)=(-(params(2)*params(1)*y(11)*T80));
  g1(2,16)=(-(params(2)*params(1)*y(11)*y(15)*getPowerDeriv(y(16),params(4),1)));
  g1(2,11)=(-(params(2)*params(1)*T80*y(15)));
  g1(2,12)=(-(T77*params(4)/(params(4)-1)*PSI__*getPowerDeriv(y(12),params(5),1)));
  g1(2,13)=(-(T73*T159*1/y(5)));
  g1(3,6)=(-((-y(13))/(y(6)*y(6))));
  g1(3,7)=1/y(9);
  g1(3,15)=(-(params(2)*params(1)*y(11)*T92));
  g1(3,16)=(-(params(2)*params(1)*y(11)*y(15)*getPowerDeriv(y(16),params(4)-1,1)/y(17)));
  g1(3,9)=(-y(7))/(y(9)*y(9));
  g1(3,17)=(-(params(2)*params(1)*y(11)*y(15)*(-T90)/(y(17)*y(17))));
  g1(3,11)=(-(params(2)*params(1)*y(15)*T92));
  g1(3,13)=(-(1/y(6)));
  g1(4,8)=(-((1-params(8))*T111*params(9)/params(1)*1/params(9)*getPowerDeriv(y(8)/params(9),params(6),1)));
  g1(4,2)=(-params(8));
  g1(4,10)=1;
  g1(4,13)=(-((1-params(8))*T107*1/YSS__*getPowerDeriv(y(13)/YSS__,params(7),1)));
  g1(5,8)=(-(params(2)*getPowerDeriv(y(8),params(4)-1,1)));
  g1(5,9)=(-((1-params(2))*getPowerDeriv(y(9),1-params(4),1)));
  g1(6,8)=(-(y(4)*params(2)*getPowerDeriv(y(8),params(4),1)));
  g1(6,9)=(-((1-params(2))*getPowerDeriv(y(9),(-params(4)),1)));
  g1(6,4)=(-T125);
  g1(6,12)=1;
  g1(7,6)=(-1);
  g1(7,13)=1-params(3);
  g1(8,3)=(-(params(12)*1/y(3)));
  g1(8,11)=1/y(11);
  g1(8,19)=(-1);
  g1(9,1)=(-(params(11)*1/y(1)));
  g1(9,5)=1/y(5);
  g1(9,18)=(-1);

if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],9,361);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],9,6859);
end
end
end
end
