function [residual, g1, g2, g3] = fv_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 9, 1);

%
% Model equations
%

XSS__ = params(4)/(params(4)-1);
pss__ = params(9);
psss__ = ((1-params(2)*pss__^(params(4)-1))/(1-params(2)))^(1/(1-params(4)));
vss__ = (1-params(2))*psss__^(-params(4))/(1-params(2)*pss__^params(4));
icsss__ = psss__/(1-pss__^(params(4)-1)*params(2)*params(1))/(1-params(3));
PSI__ = icsss__*(1-pss__^params(4)*params(2)*params(1))/(XSS__*vss__^params(5));
YSS__ = (icsss__*(1-pss__^params(4)*params(2)*params(1))/(vss__^params(5)*XSS__*PSI__))^(1/(1+params(5)));
T57 = y(2)^(-1);
T71 = params(4)/(params(4)-1)*PSI__*y(8)^params(5);
T75 = (y(9)/y(1))^(1+params(5));
T78 = y(4)^params(4);
T87 = y(4)^(params(4)-1);
T101 = params(9)/params(1)*(y(4)/params(9))^params(6);
T105 = (y(9)/YSS__)^params(7);
residual(1) = T57-params(1)*y(7)*y(6)*T57/y(4);
residual(2) = y(3)-(T71*T75+params(2)*params(1)*y(7)*y(3)*T78);
residual(3) = y(3)/y(5)-(y(9)/y(2)+params(2)*params(1)*y(7)*y(3)*T87/y(5));
residual(4) = y(6)-(y(6)*params(8)+(1-params(8))*T101*T105);
residual(5) = 1-(params(2)*T87+(1-params(2))*y(5)^(1-params(4)));
residual(6) = y(8)-(y(8)*params(2)*T78+(1-params(2))*y(5)^(-params(4)));
residual(7) = y(9)-(y(2)+params(3)*y(9));
lhs =log(y(7));
rhs =log(y(7))*params(12)+x(2);
residual(8)= lhs-rhs;
lhs =log(y(1));
rhs =log(y(1))*params(11)+x(1);
residual(9)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(9, 9);

  %
  % Jacobian matrix
  %

T143 = getPowerDeriv(y(9)/y(1),1+params(5),1);
T150 = getPowerDeriv(y(2),(-1),1);
T167 = getPowerDeriv(y(4),params(4),1);
T171 = getPowerDeriv(y(4),params(4)-1,1);
  g1(1,2)=T150-params(1)*y(7)*y(6)*T150/y(4);
  g1(1,4)=(-(params(1)*y(7)*y(6)*(-T57)/(y(4)*y(4))));
  g1(1,6)=(-(params(1)*y(7)*T57/y(4)));
  g1(1,7)=(-(T57/y(4)*params(1)*y(6)));
  g1(2,1)=(-(T71*(-y(9))/(y(1)*y(1))*T143));
  g1(2,3)=1-params(2)*params(1)*y(7)*T78;
  g1(2,4)=(-(params(2)*params(1)*y(7)*y(3)*T167));
  g1(2,7)=(-(params(2)*params(1)*y(3)*T78));
  g1(2,8)=(-(T75*params(4)/(params(4)-1)*PSI__*getPowerDeriv(y(8),params(5),1)));
  g1(2,9)=(-(T71*T143*1/y(1)));
  g1(3,2)=(-((-y(9))/(y(2)*y(2))));
  g1(3,3)=1/y(5)-params(2)*params(1)*y(7)*T87/y(5);
  g1(3,4)=(-(params(2)*params(1)*y(7)*y(3)*T171/y(5)));
  g1(3,5)=(-y(3))/(y(5)*y(5))-params(2)*params(1)*y(7)*y(3)*(-T87)/(y(5)*y(5));
  g1(3,7)=(-(params(2)*params(1)*y(3)*T87/y(5)));
  g1(3,9)=(-(1/y(2)));
  g1(4,4)=(-((1-params(8))*T105*params(9)/params(1)*1/params(9)*getPowerDeriv(y(4)/params(9),params(6),1)));
  g1(4,6)=1-params(8);
  g1(4,9)=(-((1-params(8))*T101*1/YSS__*getPowerDeriv(y(9)/YSS__,params(7),1)));
  g1(5,4)=(-(params(2)*T171));
  g1(5,5)=(-((1-params(2))*getPowerDeriv(y(5),1-params(4),1)));
  g1(6,4)=(-(y(8)*params(2)*T167));
  g1(6,5)=(-((1-params(2))*getPowerDeriv(y(5),(-params(4)),1)));
  g1(6,8)=1-params(2)*T78;
  g1(7,2)=(-1);
  g1(7,9)=1-params(3);
  g1(8,7)=1/y(7)-params(12)*1/y(7);
  g1(9,1)=1/y(1)-params(11)*1/y(1);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],9,81);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],9,729);
end
end
end
end
