function [residual, g1, g2, g3] = rank_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(12, 1);
lhs =y(15);
rhs =params(17)*y(3)+x(it_, 2);
residual(1)= lhs-rhs;
lhs =y(13);
rhs =params(15)*y(2)+x(it_, 1);
residual(2)= lhs-rhs;
lhs =(1-params(14))*y(10)+y(13)*params(14);
rhs =y(8);
residual(3)= lhs-rhs;
lhs =(1-params(14))*y(10)+y(13)*params(14);
rhs =params(12)*(y(11)+y(9))+(1-params(12))*y(12);
residual(4)= lhs-rhs;
lhs =y(10);
rhs =(-(y(6)-y(16)))+y(18)-y(15);
residual(5)= lhs-rhs;
lhs =y(4);
rhs =y(16)*params(1)+params(9)*y(14);
residual(6)= lhs-rhs;
lhs =y(5);
rhs =params(1)*y(17)-params(10)*(y(11)-(y(10)+y(9)*params(2)));
residual(7)= lhs-rhs;
lhs =y(8);
rhs =y(9)*params(16);
residual(8)= lhs-rhs;
lhs =y(14);
rhs =y(11)+y(8)*(1/params(16)-1);
residual(9)= lhs-rhs;
lhs =y(11);
rhs =y(5)+y(1)-y(4);
residual(10)= lhs-rhs;
lhs =y(6);
rhs =y(4)*params(4);
residual(11)= lhs-rhs;
lhs =y(7);
rhs =y(6)-y(16);
residual(12)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(12, 20);

  %
  % Jacobian matrix
  %

  g1(1,3)=(-params(17));
  g1(1,15)=1;
  g1(1,20)=(-1);
  g1(2,2)=(-params(15));
  g1(2,13)=1;
  g1(2,19)=(-1);
  g1(3,8)=(-1);
  g1(3,10)=1-params(14);
  g1(3,13)=params(14);
  g1(4,9)=(-params(12));
  g1(4,10)=1-params(14);
  g1(4,11)=(-params(12));
  g1(4,12)=(-(1-params(12)));
  g1(4,13)=params(14);
  g1(5,16)=(-1);
  g1(5,6)=1;
  g1(5,10)=1;
  g1(5,18)=(-1);
  g1(5,15)=1;
  g1(6,4)=1;
  g1(6,16)=(-params(1));
  g1(6,14)=(-params(9));
  g1(7,5)=1;
  g1(7,17)=(-params(1));
  g1(7,9)=params(10)*(-params(2));
  g1(7,10)=(-params(10));
  g1(7,11)=params(10);
  g1(8,8)=1;
  g1(8,9)=(-params(16));
  g1(9,8)=(-(1/params(16)-1));
  g1(9,11)=(-1);
  g1(9,14)=1;
  g1(10,4)=1;
  g1(10,5)=(-1);
  g1(10,1)=(-1);
  g1(10,11)=1;
  g1(11,4)=(-params(4));
  g1(11,6)=1;
  g1(12,16)=1;
  g1(12,6)=(-1);
  g1(12,7)=1;

if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],12,400);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],12,8000);
end
end
end
end
