function [residual, g1, g2, g3] = rank_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 12, 1);

%
% Model equations
%

lhs =y(12);
rhs =y(12)*params(17)+x(2);
residual(1)= lhs-rhs;
lhs =y(10);
rhs =y(10)*params(15)+x(1);
residual(2)= lhs-rhs;
lhs =(1-params(14))*y(7)+y(10)*params(14);
rhs =y(5);
residual(3)= lhs-rhs;
lhs =(1-params(14))*y(7)+y(10)*params(14);
rhs =params(12)*(y(8)+y(6))+(1-params(12))*y(9);
residual(4)= lhs-rhs;
lhs =y(7);
rhs =y(7)-(y(3)-y(1))-y(12);
residual(5)= lhs-rhs;
lhs =y(1);
rhs =y(1)*params(1)+params(9)*y(11);
residual(6)= lhs-rhs;
lhs =y(2);
rhs =params(1)*y(2)-params(10)*(y(8)-(y(7)+y(6)*params(2)));
residual(7)= lhs-rhs;
lhs =y(5);
rhs =y(6)*params(16);
residual(8)= lhs-rhs;
lhs =y(11);
rhs =y(8)+y(5)*(1/params(16)-1);
residual(9)= lhs-rhs;
lhs =y(8);
rhs =y(8)+y(2)-y(1);
residual(10)= lhs-rhs;
lhs =y(3);
rhs =y(1)*params(4);
residual(11)= lhs-rhs;
lhs =y(4);
rhs =y(3)-y(1);
residual(12)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(12, 12);

  %
  % Jacobian matrix
  %

  g1(1,12)=1-params(17);
  g1(2,10)=1-params(15);
  g1(3,5)=(-1);
  g1(3,7)=1-params(14);
  g1(3,10)=params(14);
  g1(4,6)=(-params(12));
  g1(4,7)=1-params(14);
  g1(4,8)=(-params(12));
  g1(4,9)=(-(1-params(12)));
  g1(4,10)=params(14);
  g1(5,1)=(-1);
  g1(5,3)=1;
  g1(5,12)=1;
  g1(6,1)=1-params(1);
  g1(6,11)=(-params(9));
  g1(7,2)=1-params(1);
  g1(7,6)=params(10)*(-params(2));
  g1(7,7)=(-params(10));
  g1(7,8)=params(10);
  g1(8,5)=1;
  g1(8,6)=(-params(16));
  g1(9,5)=(-(1/params(16)-1));
  g1(9,8)=(-1);
  g1(9,11)=1;
  g1(10,1)=1;
  g1(10,2)=(-1);
  g1(11,1)=(-params(4));
  g1(11,3)=1;
  g1(12,1)=1;
  g1(12,3)=(-1);
  g1(12,4)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],12,144);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],12,1728);
end
end
end
end
