var pi piw ihat rhat yhat nhat cwhat cchat what dhat tauhat mchat;
parameters beta varphi theta_p phi_pi phi_w rho_v theta_w epsilon_w epsilon_p lambda_p lambda_w rho Sbar xi taubar rho_tau alpha;
varexo e;

load parameters.mat

alpha=alpha_val;
beta=beta_val;
varphi=varphi_val;
theta_p=theta_p_val;
phi_pi=phi_pi_val;
theta_w=theta_w_val;
epsilon_w=epsilon_w_val;
epsilon_p=epsilon_p_val;
rho=-log(beta);
rho_v=rho_v_val;
Sbar = Sbar_val;
xi = xi_val;
taubar = taubar_val;
rho_tau = rho_tau_val;

lambda_p = (1-theta_p)*(1-beta*theta_p)/theta_p*(alpha)/(alpha+(1-alpha)*epsilon_p);
lambda_w = (epsilon_w-1)/(xi);

model(linear);
%fiscal shock
tauhat = rho_tau*tauhat(-1)+e;

%Goods market clearing
yhat = Sbar*(1-taubar)*cwhat + (1-Sbar)*(1-taubar)*cchat + taubar*tauhat;

%Bond market worker
(1-taubar)*cwhat + taubar*tauhat= nhat + what;

%Bond market capitalist
(1-taubar)*cchat + taubar*tauhat = dhat;

%Euler equation
cwhat = -(ihat-pi(+1)) + cwhat(+1);

%Good price phillipscurve
pi=beta*pi(+1)+lambda_p*mchat;

%Wage price phillipscurve
piw=beta*piw(+1)-lambda_w*(what-(cwhat+varphi*nhat));

%Wage evolution
what=what(-1)+piw-pi;

%Production function
yhat = alpha*nhat;

% marginal cost
mchat = what+(1/alpha-1)*yhat;

%Policy
ihat = phi_pi*pi;

%real interest rate
rhat = ihat-pi(+1);
end;

shocks;
var e = 0.0001;
end;

stoch_simul(order=1, nograph);

