function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = rank_rigid.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(11, 17);
g1(1,2)=(-params(15));
g1(1,12)=1;
g1(1,17)=(-1);
g1(2,7)=(-1);
g1(2,9)=1-params(14);
g1(2,12)=params(14);
g1(3,8)=(-params(12));
g1(3,9)=1-params(14);
g1(3,10)=(-params(12));
g1(3,11)=(-(1-params(12)));
g1(3,12)=params(14);
g1(4,14)=(-1);
g1(4,5)=1;
g1(4,9)=1;
g1(4,16)=(-1);
g1(5,3)=1;
g1(5,14)=(-params(1));
g1(5,13)=(-params(9));
g1(6,4)=1;
g1(6,15)=(-params(1));
g1(6,8)=params(10)*(-params(2));
g1(6,9)=(-params(10));
g1(6,10)=params(10);
g1(7,7)=1;
g1(7,8)=(-params(16));
g1(8,7)=(-(1/params(16)-1));
g1(8,10)=(-1);
g1(8,13)=1;
g1(9,3)=1;
g1(9,4)=(-1);
g1(9,1)=(-1);
g1(9,10)=1;
g1(10,3)=(-params(4));
g1(10,5)=1;
g1(11,14)=1;
g1(11,5)=(-1);
g1(11,6)=1;

end
