clear all 
clc










addpath '/Applications/Dynare/5.3/matlab'

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Standard parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
beta_val = 0.99;
varphi_val = 1;
theta_p_val = 2/3;
phi_pi_val = 1.5;
epsilon_p_val = 6;
rho_v_val = 0.5;
taubar_val = 0.3;
rho_tau_val = 0.5;
alpha_val = 1;
Sbar_val = alpha_val*(epsilon_p_val-1)/epsilon_p_val;

theta_w_val = 3/4;
epsilon_w_val = 6;
xi_val = (epsilon_w_val-1)*theta_w_val*epsilon_w_val*(1+varphi_val)/((1-theta_w_val)*(1-beta_val*theta_w_val));


%%%%%%%%%%%%%%%
%Simulate fiscal policy shock in all four models.
%Model 1: RANK model sticky prices
%Model 2: SHANK model sticky prices
%Model 3: RANK model flexible prices
%Model 4: SHANK model flexible prices
%%%%%%%%%%%%%%%k

%%Note: In SHANK, we assume that steady state taxes as share of income is
%%the same of capitalists as it is for workers

save('parameters.mat', 'beta_val', 'varphi_val', 'theta_p_val', 'phi_pi_val', 'epsilon_p_val',...
                       'rho_v_val', 'Sbar_val', 'theta_w_val', 'epsilon_w_val','xi_val')
save result.mat

%Model 1: RANK model sticky prices and sticky wages
dynare rank_rigid.mod;
load('result.mat', 'tauhat_rank', 'chat_rank', 'dhat_rank', 'what_rank', 'yhat_rank', 'nhat_rank', 'rhat_rank', 'pi_rank')
tauhat_rank(:,1) = tauhat_e;
chat_rank(:,1) = chat_e;
dhat_rank(:,1) = dhat_e;
what_rank(:,1) = what_e;
yhat_rank(:,1) = yhat_e;
nhat_rank(:,1) = nhat_e;
rhat_rank(:,1) = rhat_e;
pi_rank(:,1) = pi_e;
save('result.mat', 'tauhat_rank', 'chat_rank', 'dhat_rank', 'what_rank', 'yhat_rank', 'nhat_rank', 'rhat_rank', 'pi_rank', '-append')

%Model 2: SHANK model sticky prices and sticky wages
dynare shank_rigid.mod;
load('result.mat', 'tauhat_shank', 'cchat_shank', 'cwhat_shank', 'dhat_shank', 'what_shank', 'yhat_shank', 'nhat_shank', 'rhat_shank', 'pi_shank')
tauhat_shank(:,1) = tauhat_e;
cchat_shank(:,1) = cchat_e;
cwhat_shank(:,1) = cwhat_e;
dhat_shank(:,1) = dhat_e;
what_shank(:,1) = what_e;
yhat_shank(:,1) = yhat_e;
nhat_shank(:,1) = nhat_e;
rhat_shank(:,1) = rhat_e;
pi_shank(:,1) = pi_e;
save('result.mat', 'tauhat_shank', 'cchat_shank', 'cwhat_shank', 'dhat_shank', 'what_shank', 'yhat_shank', 'nhat_shank', 'rhat_shank', 'pi_shank', '-append')

theta_p_val = 2/3;
theta_w_val = 0.0001;
xi_val = (epsilon_w_val-1)*theta_w_val*epsilon_w_val*(1+varphi_val)/((1-theta_w_val)*(1-beta_val*theta_w_val));
save('parameters.mat', 'beta_val', 'varphi_val', 'theta_p_val', 'phi_pi_val', 'epsilon_p_val',...
                       'rho_v_val', 'Sbar_val', 'theta_w_val', 'epsilon_w_val','xi_val')

%Model 3: RANK model sticky prices and flexible wages
dynare rank_rigid.mod;
load('result.mat', 'tauhat_rank', 'chat_rank', 'dhat_rank', 'what_rank', 'yhat_rank', 'nhat_rank', 'rhat_rank', 'pi_rank')
tauhat_rank(:,2) = tauhat_e;
chat_rank(:,2) = chat_e;
dhat_rank(:,2) = dhat_e;
what_rank(:,2) = what_e;
yhat_rank(:,2) = yhat_e;
nhat_rank(:,2) = nhat_e;
rhat_rank(:,2) = rhat_e;
pi_rank(:,2) = pi_e;
save('result.mat', 'tauhat_rank', 'chat_rank', 'dhat_rank', 'what_rank', 'yhat_rank', 'nhat_rank', 'rhat_rank', 'pi_rank', '-append')

%Model 4: RANK model sticky prices and flexible wages
dynare shank_rigid.mod;
load('result.mat', 'tauhat_shank', 'cchat_shank', 'cwhat_shank', 'dhat_shank', 'what_shank', 'yhat_shank', 'nhat_shank', 'rhat_shank', 'pi_shank')
tauhat_shank(:,2) = tauhat_e;
cwhat_shank(:,2) = chat_e;
dhat_shank(:,2) = dhat_e;
what_shank(:,2) = what_e;
yhat_shank(:,2) = yhat_e;
nhat_shank(:,2) = nhat_e;
rhat_shank(:,2) = rhat_e;
pi_shank(:,2) = pi_e;
save('result.mat', 'tauhat_shank', 'cchat_shank', 'cwhat_shank', 'dhat_shank', 'what_shank', 'yhat_shank', 'nhat_shank', 'rhat_shank', 'pi_shank', '-append')

theta_p_val = 0.000001;
theta_w_val = 3/4;
xi_val = (epsilon_w_val-1)*theta_w_val*epsilon_w_val*(1+varphi_val)/((1-theta_w_val)*(1-beta_val*theta_w_val));
save('parameters.mat', 'beta_val', 'varphi_val', 'theta_p_val', 'phi_pi_val', 'epsilon_p_val',...
                       'rho_v_val', 'Sbar_val', 'theta_w_val', 'epsilon_w_val','xi_val')

%Model 5: RANK model flexible prices and sticky wages
dynare rank_rigid.mod;
load('result.mat', 'tauhat_rank', 'chat_rank', 'dhat_rank', 'what_rank', 'yhat_rank', 'nhat_rank', 'rhat_rank', 'pi_rank')
tauhat_rank(:,3) = tauhat_e;
chat_rank(:,3) = chat_e;
dhat_rank(:,3) = dhat_e;
what_rank(:,3) = what_e;
yhat_rank(:,3) = yhat_e;
nhat_rank(:,3) = nhat_e;
rhat_rank(:,3) = rhat_e;
pi_rank(:,3) = pi_e;
save('result.mat', 'tauhat_rank', 'chat_rank', 'dhat_rank', 'what_rank', 'yhat_rank', 'nhat_rank', 'rhat_rank', 'pi_rank', '-append')

%Model 6: RANK model flexible prices and sticky wages
dynare shank_rigid.mod;
load('result.mat', 'tauhat_shank', 'cchat_shank', 'cwhat_shank', 'dhat_shank', 'what_shank', 'yhat_shank', 'nhat_shank', 'rhat_shank', 'pi_shank')
tauhat_shank(:,3) = tauhat_e;
cwhat_shank(:,3) = chat_e;
dhat_shank(:,3) = dhat_e;
what_shank(:,3) = what_e;
yhat_shank(:,3) = yhat_e;
nhat_shank(:,3) = nhat_e;
rhat_shank(:,3) = rhat_e;
pi_shank(:,3) = pi_e;
save('result.mat', 'tauhat_shank', 'cchat_shank', 'cwhat_shank', 'dhat_shank', 'what_shank', 'yhat_shank', 'nhat_shank', 'rhat_shank', 'pi_shank', '-append')
                   
theta_p_val = 0.00000001;
theta_w_val = 0.00000001;
xi_val = (epsilon_w_val-1)*theta_w_val*epsilon_w_val*(1+varphi_val)/((1-theta_w_val)*(1-beta_val*theta_w_val));
save('parameters.mat', 'beta_val', 'varphi_val', 'theta_p_val', 'phi_pi_val', 'epsilon_p_val',...
                       'rho_v_val', 'Sbar_val', 'theta_w_val', 'epsilon_w_val','xi_val')

%Model 7: RANK model flexible prices and flexible wages
dynare rank_rigid.mod;
load('result.mat', 'tauhat_rank', 'chat_rank', 'dhat_rank', 'what_rank', 'yhat_rank', 'nhat_rank', 'rhat_rank', 'pi_rank')
tauhat_rank(:,4) = tauhat_e;
chat_rank(:,4) = chat_e;
dhat_rank(:,4) = dhat_e;
what_rank(:,4) = what_e;
yhat_rank(:,4) = yhat_e;
nhat_rank(:,4) = nhat_e;
rhat_rank(:,4) = rhat_e;
pi_rank(:,4) = pi_e;
save('result.mat', 'tauhat_rank', 'chat_rank', 'dhat_rank', 'what_rank', 'yhat_rank', 'nhat_rank', 'rhat_rank', 'pi_rank', '-append')

%Model 8: RANK model flexible prices and flexible wages
dynare shank_rigid.mod;
load('result.mat', 'tauhat_shank', 'cchat_shank', 'cwhat_shank', 'dhat_shank', 'what_shank', 'yhat_shank', 'nhat_shank', 'rhat_shank', 'pi_shank')
tauhat_shank(:,4) = tauhat_e;
cwhat_shank(:,4) = chat_e;
dhat_shank(:,4) = dhat_e;
what_shank(:,4) = what_e;
yhat_shank(:,4) = yhat_e;
nhat_shank(:,4) = nhat_e;
rhat_shank(:,4) = rhat_e;
pi_shank(:,4) = pi_e;
save('result.mat', 'tauhat_shank', 'cchat_shank', 'cwhat_shank', 'dhat_shank', 'what_shank', 'yhat_shank', 'nhat_shank', 'rhat_shank', 'pi_shank', '-append')
                   
                          
                   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%  Plots  %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('result.mat')
FigHandle = figure('Position', [0, 0, 800, 600]);

R=3;
C=3;
T=4;
size=12;


subplot(R,C,1)
plot(1:T, 100.*squeeze(what_rank(1:T, 2)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(what_shank(1:T, 2)), '--', 'Linewidth', 2); hold on;
title({'\fontsize{15}Sticky prices','\fontsize{2} ', '\fontsize{12}Real Wages'}); grid on
axis([1 T 0.0 0.2]);
legend('RANK','HANK','Location','northeast')
ylabel('Percent')

subplot(R,C,2)
plot(1:T, 100.*squeeze(what_rank(1:T, 3)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(what_shank(1:T, 3)), '--', 'Linewidth', 2); hold on;
title({'\fontsize{15}Sticky wages','\fontsize{2} ', '\fontsize{12}Real Wages'}); grid on
axis([1 T 0.0 0.2]);

subplot(R,C,3)
plot(1:T, 100.*squeeze(what_rank(1:T, 1)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(what_shank(1:T, 1)), '--', 'Linewidth', 2); hold on;
title({'\fontsize{15}Sticky prices & wages','\fontsize{2} ', '\fontsize{12}Real Wages'}); grid on
axis([1 T 0.0 0.2]);


subplot(R,C,4)
plot(1:T, 100.*squeeze(dhat_rank(1:T, 2)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(dhat_shank(1:T, 2)), '--', 'Linewidth', 2); hold on;
title('Profits'); grid on
xlabel('Quarters')
axis([1 T -1.0 0.5]);
ylabel('Percent')

subplot(R,C,5)
plot(1:T, 100.*squeeze(dhat_rank(1:T, 3)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(dhat_shank(1:T, 3)), '--', 'Linewidth', 2); hold on;
title('Profits'); grid on
xlabel('Quarters')
axis([1 T -1.0 0.5]);

subplot(R,C,6)
plot(1:T, 100.*squeeze(dhat_rank(1:T, 1)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(dhat_shank(1:T, 1)), '--', 'Linewidth', 2); hold on;
title('Profits'); grid on
xlabel('Quarters')
axis([1 T -1.0 0.5]);

subplot(R,C,7)
plot(1:T, 100.*(squeeze(yhat_rank(1:T, 2))-squeeze(yhat_rank(1:T, 4))), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*(squeeze(yhat_shank(1:T, 2))-squeeze(yhat_shank(1:T, 4))), '--', 'Linewidth', 2); hold on;
title('Output gap'); grid on
axis([1 T -0.05 0.15]);
ylabel('Percent')
xlabel('Quarters')

subplot(R,C,8)
plot(1:T, 100.*(squeeze(yhat_rank(1:T, 3))-squeeze(yhat_rank(1:T, 4))), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*(squeeze(yhat_shank(1:T, 3))-squeeze(yhat_shank(1:T, 4))), '--', 'Linewidth', 2); hold on;
title('Output gap'); grid on
axis([1 T -0.05 0.15]);
xlabel('Quarters')

subplot(R,C,9)
plot(1:T, 100.*(squeeze(yhat_rank(1:T, 1))-squeeze(yhat_rank(1:T, 4))), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*(squeeze(yhat_shank(1:T, 1))-squeeze(yhat_shank(1:T, 4))), '--', 'Linewidth', 2); hold on;
title('Output gap'); grid on
axis([1 T -0.05 0.15]);
xlabel('Quarters')
saveas(FigHandle,'main_panel', 'pdf')


 
load('result.mat')
FigHandle = figure('Position', [0, 0, 850, 900]);

R=6;
C=4;
T=4;
size=12;

subplot(R,C,1)
plot(1:T, 100.*squeeze(tauhat_rank(1:T, 4)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(tauhat_shank(1:T, 4)), '--', 'Linewidth', 2); hold on;
title({'\fontsize{15}No rigidity','\fontsize{2} ', '\fontsize{12}Government spending'}); grid on
ylabel('Percent')
legend('RANK','HANK','Location','best')
axis([1 T 0 1])

subplot(R,C,2)
plot(1:T, 100.*squeeze(tauhat_rank(1:T, 2)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(tauhat_shank(1:T, 2)), '--', 'Linewidth', 2); hold on;
title({'\fontsize{15}Sticky prices','\fontsize{2} ', '\fontsize{12}Government spending'}); grid on
axis([1 T 0 1])

subplot(R,C,3)
plot(1:T, 100.*squeeze(tauhat_rank(1:T, 3)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(tauhat_shank(1:T, 3)), '--', 'Linewidth', 2); hold on;
title({'\fontsize{15}Sticky wages','\fontsize{2} ', '\fontsize{12}Government spending'}); grid on
axis([1 T 0 1])

subplot(R,C,4)
plot(1:T, 100.*squeeze(tauhat_rank(1:T, 1)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(tauhat_shank(1:T, 1)), '--', 'Linewidth', 2); hold on;
title({'\fontsize{15}Sticky prices & wages','\fontsize{2} ', '\fontsize{12}Government spending'}); grid on
axis([1 T 0 1])

subplot(R,C,5)
plot(1:T, 100.*squeeze(4*rhat_rank(1:T, 4)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(4*rhat_shank(1:T, 4)), '--', 'Linewidth', 2); hold on;
title('Real interest rate'); grid on
ylabel('PPt, ann. level')
axis([1 T 0.0 0.4]);

subplot(R,C,6)
plot(1:T, 100.*squeeze(4*rhat_rank(1:T, 2)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(4*rhat_shank(1:T, 2)), '--', 'Linewidth', 2); hold on;
title('Real interest rate'); grid on
axis([1 T 0.0 0.4]);

subplot(R,C,7)
plot(1:T, 100.*squeeze(4*rhat_rank(1:T, 3)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(4*rhat_shank(1:T, 3)), '--', 'Linewidth', 2); hold on;
title('Real interest rate'); grid on
axis([1 T 0.0 0.4]);

subplot(R,C,8)
plot(1:T, 100.*squeeze(4*rhat_rank(1:T, 1)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(4*rhat_shank(1:T, 1)), '--', 'Linewidth', 2); hold on;
title('Real interest rate'); grid on
axis([1 T 0.0 0.4]);

subplot(R,C,9)
plot(1:T, 100.*squeeze(4*pi_rank(1:T, 4)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(4*pi_shank(1:T, 4)), '--', 'Linewidth', 2); hold on;
title('Inflation'); grid on
ylabel('PPt, ann. level')
axis([1 T 0.0 0.4]);

subplot(R,C,10)
plot(1:T, 100.*squeeze(4*pi_rank(1:T, 2)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(4*pi_shank(1:T, 2)), '--', 'Linewidth', 2); hold on;
title('Inflation'); grid on
axis([1 T 0.0 0.4]);

subplot(R,C,11)
plot(1:T, 100.*squeeze(4*pi_rank(1:T, 3)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(4*pi_shank(1:T, 3)), '--', 'Linewidth', 2); hold on;
title('Inflation'); grid on
axis([1 T 0.0 0.4]);

subplot(R,C,12)
plot(1:T, 100.*squeeze(4*pi_rank(1:T, 1)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(4*pi_shank(1:T, 1)), '--', 'Linewidth', 2); hold on;
title('Inflation'); grid on
axis([1 T 0.0 0.4]);

subplot(R,C,13)
plot(1:T, 100.*squeeze(yhat_rank(1:T, 4)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(yhat_shank(1:T, 4)), '--', 'Linewidth', 2); hold on;
title('Output'); grid on
ylabel('Percent')
axis([1 T 0 0.3]);

subplot(R,C,14)
plot(1:T, 100.*squeeze(yhat_rank(1:T, 2)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(yhat_shank(1:T, 2)), '--', 'Linewidth', 2); hold on;
title('Output'); grid on
axis([1 T 0 0.3]);

subplot(R,C,15)
plot(1:T, 100.*squeeze(yhat_rank(1:T, 3)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(yhat_shank(1:T, 3)), '--', 'Linewidth', 2); hold on;
title('Output'); grid on
axis([1 T 0 0.3]);

subplot(R,C,16)
plot(1:T, 100.*squeeze(yhat_rank(1:T, 1)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(yhat_shank(1:T, 1)), '--', 'Linewidth', 2); hold on;
title('Output'); grid on
axis([1 T 0 0.3]);

subplot(R,C,17)
plot(1:T, 100.*squeeze(what_rank(1:T, 4)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(what_shank(1:T, 4)), '--', 'Linewidth', 2); hold on;
title('Real Wages'); grid on
ylabel('Percent')
axis([1 T 0.0 0.2]);

subplot(R,C,18)
plot(1:T, 100.*squeeze(what_rank(1:T, 2)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(what_shank(1:T, 2)), '--', 'Linewidth', 2); hold on;
title('Real Wages'); grid on
axis([1 T 0.0 0.2]);

subplot(R,C,19)
plot(1:T, 100.*squeeze(what_rank(1:T, 3)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(what_shank(1:T, 3)), '--', 'Linewidth', 2); hold on;
title('Real Wages'); grid on
axis([1 T 0.0 0.2]);

subplot(R,C,20)
plot(1:T, 100.*squeeze(what_rank(1:T, 1)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(what_shank(1:T, 1)), '--', 'Linewidth', 2); hold on;
title('Real Wages'); grid on
axis([1 T 0.0 0.2]);

subplot(R,C,21)
plot(1:T, 100.*squeeze(dhat_rank(1:T, 4)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(dhat_shank(1:T, 4)), '--', 'Linewidth', 2);
title('Profits'); grid on
xlabel('Quarters')
ylabel('Percent')
axis([1 T -0.5 0.5]);

subplot(R,C,22)
plot(1:T, 100.*squeeze(dhat_rank(1:T, 2)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(dhat_shank(1:T, 2)), '--', 'Linewidth', 2); hold on;
title('Profits'); grid on
xlabel('Quarters')
axis([1 T -0.5 0.5]);

subplot(R,C,23)
plot(1:T, 100.*squeeze(dhat_rank(1:T, 3)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(dhat_shank(1:T, 3)), '--', 'Linewidth', 2); hold on;
title('Profits'); grid on
xlabel('Quarters')
axis([1 T -0.5 0.5]);

subplot(R,C,24)
plot(1:T, 100.*squeeze(dhat_rank(1:T, 1)), '-', 'Linewidth', 2); hold on;
plot(1:T, 100.*squeeze(dhat_shank(1:T, 1)), '--', 'Linewidth', 2); hold on;
title('Profits'); grid on
xlabel('Quarters')
axis([1 T -0.5 0.5]);
saveas(FigHandle,'app_panel', 'pdf')

%Multipliers
disp('Multiplier rank, sticky prices');
disp(sum(100.*squeeze(yhat_rank(:, 2)))/sum(taubar.*100.*squeeze(tauhat_rank(:, 2))));
disp('Multiplier shank, sticky prices');
disp(sum(100.*squeeze(yhat_shank(:, 2)))/sum(taubar.*100.*squeeze(tauhat_shank(:, 2))));
disp('Multiplier rank, sticky wages');
disp(sum(100.*squeeze(yhat_rank(:, 3)))/sum(taubar.*100.*squeeze(tauhat_rank(:, 3))));
disp('Multiplier shank, sticky wages');
disp(sum(100.*squeeze(yhat_shank(:, 3)))/sum(taubar.*100.*squeeze(tauhat_shank(:, 3))));

disp('Multiplier rank, sticky prices and sticky wages');
disp(sum(100.*squeeze(yhat_rank(:, 1)))/sum(taubar.*100.*squeeze(tauhat_rank(:, 1))));
disp('Multiplier shank, sticky prices and sticky wages');
disp(sum(100.*squeeze(yhat_shank(:, 1)))/sum(taubar.*100.*squeeze(tauhat_shank(:, 1))));

disp('Multiplier rank, no rigidty');
disp(sum(100.*squeeze(yhat_rank(:, 4)))/sum(taubar.*100.*squeeze(tauhat_rank(:, 4))));
disp('Multiplier shank, no rigidty');
disp(sum(100.*squeeze(yhat_shank(:, 4)))/sum(taubar.*100.*squeeze(tauhat_shank(:, 4))));
