%% set inputs for solution below
%  The program produces responses to the shocks selected below under
%  irfshock. Paths for all the endogenous variables in the model selected
%  are produced. VariableName_difference holds the piece-wise linear solution for
%  VariableName.  VariableName_uncdifference holds the linear solution for
%  VariableName.


clear

global M_ oo_

beta_val = 0.99;
theta_p_val = 2/3;
phi_pi_val = 1.5;
epsilon_p_val = 6;
taubar_val = 0.3;
varphi_val = 1;
izlb_val = log(beta_val);
rho_tau_val = 0.5;
rho_u_val = 0.85;

alpha_val = 1;
Sbar_val = alpha_val*(epsilon_p_val-1)/epsilon_p_val;
theta_w_val = 3/4;
epsilon_w_val = 6;
xi_val = (epsilon_w_val-1)*theta_w_val*epsilon_w_val*(1+varphi_val)/((1-theta_w_val)*(1-beta_val*theta_w_val));

lambda_p_val = (1-theta_p_val)*(1-beta_val*theta_p_val)/theta_p_val*(alpha_val)/(alpha_val+(1-alpha_val)*epsilon_p_val);
lambda_w_val = (epsilon_w_val-1)/(xi_val);

save('parameters.mat', 'beta_val', 'theta_p_val', 'phi_pi_val', 'epsilon_p_val', 'taubar_val',...
                       'varphi_val', 'izlb_val', 'rho_tau_val', 'rho_u_val','Sbar_val',...
                       'alpha_val', 'theta_w_val', 'epsilon_w_val', 'xi_val', 'lambda_p_val', 'lambda_w_val')

constraint = 'ihat<izlb';
constraint_relax ='ihat>izlb';

% Pick innovation for IRFs
irfshock =char('e_t','e_u');      % label for innovation for IRFs

maxiter = 10;
tol0 = 1e-8;
nperiods = 200;


%Fiscal shock, normal times
shockssequence = [ zeros(3,2)
            0  0
            0.01  0
            zeros(39,2) ] ;

% Solve RANK model, generate model IRFs
modnam = 'rank';
modnamstar = 'rank_zlb';

[zdatalinear zdatapiecewise zdatass oobase_ Mbase_  ] = ...
  solve_one_constraint(modnam,modnamstar,...
  constraint, constraint_relax,...
  shockssequence,irfshock,nperiods);                       

for i=1:M_.endo_nbr
  eval([deblank(M_.endo_names(i,:)),'_u_rank_fiscal=zdatalinear(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_p_rank_fiscal=zdatapiecewise(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_ss_rank_fiscal=zdatass(i);']);
end

% Solve SHANK model, generate model IRFs
modnam = 'shank';
modnamstar = 'shank_zlb';

[zdatalinear zdatapiecewise zdatass oobase_ Mbase_  ] = ...
  solve_one_constraint(modnam,modnamstar,...
  constraint, constraint_relax,...
  shockssequence,irfshock,nperiods);                       

for i=1:M_.endo_nbr
  eval([deblank(M_.endo_names(i,:)),'_u_shank_fiscal=zdatalinear(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_p_shank_fiscal=zdatapiecewise(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_ss_shank_fiscal=zdatass(i);']);
end


%ZLB, no fiscal shock
shockssequence = [ zeros(3,2)
            0  0.06
            0  0            
            zeros(39,2) ] ;

% Solve RANK model, generate model IRFs
modnam = 'rank';
modnamstar = 'rank_zlb';

[zdatalinear zdatapiecewise zdatass oobase_ Mbase_  ] = ...
  solve_one_constraint(modnam,modnamstar,...
  constraint, constraint_relax,...
  shockssequence,irfshock,nperiods);
                       
for i=1:M_.endo_nbr
  eval([deblank(M_.endo_names(i,:)),'_u_rank_zlb=zdatalinear(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_p_rank_zlb=zdatapiecewise(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_ss_rank_zlb=zdatass(i);']);
end

% Solve SHANK model, generate model IRFs
modnam = 'shank';
modnamstar = 'shank_zlb';

[zdatalinear zdatapiecewise zdatass oobase_ Mbase_  ] = ...
  solve_one_constraint(modnam,modnamstar,...
  constraint, constraint_relax,...
  shockssequence,irfshock,nperiods);
                       
for i=1:M_.endo_nbr
  eval([deblank(M_.endo_names(i,:)),'_u_shank_zlb=zdatalinear(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_p_shank_zlb=zdatapiecewise(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_ss_shank_zlb=zdatass(i);']);
end


%ZLB, fiscal shock
shockssequence = [ zeros(3,2)
            0  0.06
            0.01  0
            zeros(39,2) ] ;

% Solve RANK model, generate model IRFs
modnam = 'rank';
modnamstar = 'rank_zlb';

[zdatalinear zdatapiecewise zdatass oobase_ Mbase_  ] = ...
  solve_one_constraint(modnam,modnamstar,...
  constraint, constraint_relax,...
  shockssequence,irfshock,nperiods);
                        
for i=1:M_.endo_nbr
  eval([deblank(M_.endo_names(i,:)),'_u_rank_zlb_fiscal=zdatalinear(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_p_rank_zlb_fiscal=zdatapiecewise(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_ss_rank_zlb_fiscal=zdatass(i);']);
end


% Solve SHANK model, generate model IRFs
modnam = 'shank';
modnamstar = 'shank_zlb';

[zdatalinear zdatapiecewise zdatass oobase_ Mbase_  ] = ...
  solve_one_constraint(modnam,modnamstar,...
  constraint, constraint_relax,...
  shockssequence,irfshock,nperiods);
                        
for i=1:M_.endo_nbr
  eval([deblank(M_.endo_names(i,:)),'_u_shank_zlb_fiscal=zdatalinear(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_p_shank_zlb_fiscal=zdatapiecewise(:,i);']);
  eval([deblank(M_.endo_names(i,:)),'_ss_shank_zlb_fiscal=zdatass(i);']);
end



% Figures
FigHandle = figure('Position', [0, 0, 800, 700]);
xlimits = [0, 20];

subplot(3,2,1)
plot(400*ihat_p_rank_fiscal,'-', 'Linewidth', 2);  hold on
plot(400*ihat_p_rank_zlb,'--', 'Linewidth', 2);
title({'\fontsize{15}RANK','\fontsize{2} ', '\fontsize{12}Interest rate'}); grid on
ylabel('PPt, ann. Level')
legend('fiscal shock','fiscal + beta shock')
xlim(xlimits)
ylim([-5, 10])
hold off

subplot(3,2,2)
plot(400*ihat_p_shank_fiscal,'-', 'Linewidth', 2);  hold on
plot(400*ihat_p_shank_zlb,'--', 'Linewidth', 2);
title({'\fontsize{15}Simple HANK','\fontsize{2} ', '\fontsize{12}Interest rate'}); grid on
legend('fiscal shock','fiscal + beta shock')
xlim(xlimits)
ylim([-5, 10])
hold off

subplot(3,2,3)
plot(400*pi_p_rank_fiscal,'-', 'Linewidth', 2); hold on
plot(400*(pi_p_rank_zlb_fiscal-pi_p_rank_zlb),'--', 'Linewidth', 2);
title('Inflation')
ylabel('PPt, ann. Level')
xlim(xlimits)
hold off

subplot(3,2,4)
plot(400*pi_p_shank_fiscal,'-', 'Linewidth', 2); hold on
plot(400*(pi_p_shank_zlb_fiscal-pi_p_shank_zlb),'--', 'Linewidth', 2);
title('Inflation')
xlim(xlimits)
hold off

subplot(3,2,5)
plot(100*yhat_p_rank_fiscal,'-', 'Linewidth', 2); hold on
plot(100*(yhat_p_rank_zlb_fiscal-yhat_p_rank_zlb),'--', 'Linewidth', 2);
title('Output')
ylabel('Percent')
xlabel('Quarters')
xlim(xlimits)
hold off

subplot(3,2,6)
plot(100*yhat_p_shank_fiscal,'-', 'Linewidth', 2); hold on
plot(100*(yhat_p_shank_zlb_fiscal-yhat_p_shank_zlb),'--', 'Linewidth', 2);
title('Output')
xlabel('Quarters')
xlim(xlimits)
hold off

% saveas(FigHandle,'ZLB_stickywages', 'pdf')

%Multipliers
disp('RANK Cumulative multiplier, zlb')
disp(sum(100.*squeeze((yhat_p_rank_zlb_fiscal-yhat_p_rank_zlb)))/sum(taubar*100.*squeeze(tauhat_p_rank_zlb_fiscal)));
disp('RANK Cumulative multiplier, normal times')
disp(sum(100.*squeeze((yhat_p_rank_fiscal)))/sum(taubar*100.*squeeze(tauhat_p_rank_zlb_fiscal)));
disp('SHANK Cumulative multiplier, zlb')
disp(sum(100.*squeeze((yhat_p_shank_zlb_fiscal-yhat_p_shank_zlb)))/sum(taubar*100.*squeeze(tauhat_p_shank_zlb_fiscal)));
disp('SHANK Cumulative multiplier, normal times')
disp(sum(100.*squeeze((yhat_p_shank_fiscal)))/sum(taubar*100.*squeeze(tauhat_p_shank_zlb_fiscal)));


