function [residual, g1, g2, g3] = fv_zlb_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(9, 1);
XSS__ = params(4)/(params(4)-1);
pss__ = params(9);
psss__ = ((1-params(2)*pss__^(params(4)-1))/(1-params(2)))^(1/(1-params(4)));
vss__ = (1-params(2))*psss__^(-params(4))/(1-params(2)*pss__^params(4));
icsss__ = psss__/(1-pss__^(params(4)-1)*params(2)*params(1))/(1-params(3));
PSI__ = icsss__*(1-pss__^params(4)*params(2)*params(1))/(XSS__*vss__^params(5));
T63 = y(13)^(-1);
T65 = T63/y(15);
T72 = XSS__*PSI__*y(11)^params(5);
T76 = (y(12)/y(4))^(1+params(5));
T79 = y(15)^params(4);
T89 = y(15)^(params(4)-1);
T91 = T89/y(16);
T109 = params(2)*y(7)^params(4);
residual(1) = y(5)^(-1)-params(1)*y(10)*y(9)*T65;
residual(2) = y(6)-(T72*T76+params(2)*params(1)*y(10)*T79*y(14));
residual(3) = y(6)/y(8)-(y(12)/y(5)+params(2)*params(1)*y(10)*y(14)*T91);
residual(4) = y(9)-params(10);
residual(5) = 1-(params(2)*y(7)^(params(4)-1)+(1-params(2))*y(8)^(1-params(4)));
residual(6) = y(11)-(T109*y(3)+(1-params(2))*y(8)^(-params(4)));
residual(7) = y(12)-(y(5)+params(3)*y(12));
lhs =log(y(10));
rhs =params(12)*log(y(2))+x(it_, 2);
residual(8)= lhs-rhs;
lhs =log(y(4));
rhs =params(11)*log(y(1))+x(it_, 1);
residual(9)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(9, 18);

  %
  % Jacobian matrix
  %

T143 = getPowerDeriv(y(12)/y(4),1+params(5),1);
T147 = 1/y(4);
T152 = getPowerDeriv(y(13),(-1),1);
T165 = params(2)*getPowerDeriv(y(7),params(4),1);
T173 = getPowerDeriv(y(15),params(4),1);
T177 = getPowerDeriv(y(15),params(4)-1,1);
T178 = T177/y(16);
T212 = XSS__*PSI__*getPowerDeriv(y(11),params(5),1);
  g1(1,5)=getPowerDeriv(y(5),(-1),1);
  g1(1,13)=(-(params(1)*y(10)*y(9)*T152/y(15)));
  g1(1,15)=(-(params(1)*y(10)*y(9)*(-T63)/(y(15)*y(15))));
  g1(1,9)=(-(params(1)*y(10)*T65));
  g1(1,10)=(-(T65*params(1)*y(9)));
  g1(2,4)=(-(T72*(-y(12))/(y(4)*y(4))*T143));
  g1(2,6)=1;
  g1(2,14)=(-(params(2)*params(1)*y(10)*T79));
  g1(2,15)=(-(params(2)*params(1)*y(10)*y(14)*T173));
  g1(2,10)=(-(params(2)*params(1)*T79*y(14)));
  g1(2,11)=(-(T76*T212));
  g1(2,12)=(-(T72*T143*T147));
  g1(3,5)=(-((-y(12))/(y(5)*y(5))));
  g1(3,6)=1/y(8);
  g1(3,14)=(-(params(2)*params(1)*y(10)*T91));
  g1(3,15)=(-(params(2)*params(1)*y(10)*y(14)*T178));
  g1(3,8)=(-y(6))/(y(8)*y(8));
  g1(3,16)=(-(params(2)*params(1)*y(10)*y(14)*(-T89)/(y(16)*y(16))));
  g1(3,10)=(-(params(2)*params(1)*y(14)*T91));
  g1(3,12)=(-(1/y(5)));
  g1(4,9)=1;
  g1(5,7)=(-(params(2)*getPowerDeriv(y(7),params(4)-1,1)));
  g1(5,8)=(-((1-params(2))*getPowerDeriv(y(8),1-params(4),1)));
  g1(6,7)=(-(y(3)*T165));
  g1(6,8)=(-((1-params(2))*getPowerDeriv(y(8),(-params(4)),1)));
  g1(6,3)=(-T109);
  g1(6,11)=1;
  g1(7,5)=(-1);
  g1(7,12)=1-params(3);
  g1(8,2)=(-(params(12)*1/y(2)));
  g1(8,10)=1/y(10);
  g1(8,18)=(-1);
  g1(9,1)=(-(params(11)*1/y(1)));
  g1(9,4)=T147;
  g1(9,17)=(-1);

if nargout >= 3,
  %
  % Hessian matrix
  %

  v2 = zeros(61,3);
T251 = getPowerDeriv(y(12)/y(4),1+params(5),2);
T252 = (-y(12))/(y(4)*y(4))*T251;
  v2(1,1)=1;
  v2(1,2)=77;
  v2(1,3)=getPowerDeriv(y(5),(-1),2);
  v2(2,1)=1;
  v2(2,2)=229;
  v2(2,3)=(-(params(1)*y(10)*y(9)*getPowerDeriv(y(13),(-1),2)/y(15)));
  v2(3,1)=1;
  v2(3,2)=265;
  v2(3,3)=(-(params(1)*y(10)*y(9)*(-T152)/(y(15)*y(15))));
  v2(4,1)=1;
  v2(4,2)=231;
  v2(4,3)=  v2(3,3);
  v2(5,1)=1;
  v2(5,2)=267;
  v2(5,3)=(-(params(1)*y(10)*y(9)*(-((-T63)*(y(15)+y(15))))/(y(15)*y(15)*y(15)*y(15))));
  v2(6,1)=1;
  v2(6,2)=157;
  v2(6,3)=(-(params(1)*y(10)*T152/y(15)));
  v2(7,1)=1;
  v2(7,2)=225;
  v2(7,3)=  v2(6,3);
  v2(8,1)=1;
  v2(8,2)=159;
  v2(8,3)=(-(params(1)*y(10)*(-T63)/(y(15)*y(15))));
  v2(9,1)=1;
  v2(9,2)=261;
  v2(9,3)=  v2(8,3);
  v2(10,1)=1;
  v2(10,2)=175;
  v2(10,3)=(-(T152/y(15)*params(1)*y(9)));
  v2(11,1)=1;
  v2(11,2)=226;
  v2(11,3)=  v2(10,3);
  v2(12,1)=1;
  v2(12,2)=177;
  v2(12,3)=(-((-T63)/(y(15)*y(15))*params(1)*y(9)));
  v2(13,1)=1;
  v2(13,2)=262;
  v2(13,3)=  v2(12,3);
  v2(14,1)=1;
  v2(14,2)=171;
  v2(14,3)=(-(params(1)*T65));
  v2(15,1)=1;
  v2(15,2)=154;
  v2(15,3)=  v2(14,3);
  v2(16,1)=2;
  v2(16,2)=58;
  v2(16,3)=(-(T72*(T143*(-((-y(12))*(y(4)+y(4))))/(y(4)*y(4)*y(4)*y(4))+(-y(12))/(y(4)*y(4))*T252)));
  v2(17,1)=2;
  v2(17,2)=266;
  v2(17,3)=(-(params(2)*params(1)*y(10)*T173));
  v2(18,1)=2;
  v2(18,2)=249;
  v2(18,3)=  v2(17,3);
  v2(19,1)=2;
  v2(19,2)=267;
  v2(19,3)=(-(params(2)*params(1)*y(10)*y(14)*getPowerDeriv(y(15),params(4),2)));
  v2(20,1)=2;
  v2(20,2)=176;
  v2(20,3)=(-(params(2)*params(1)*T79));
  v2(21,1)=2;
  v2(21,2)=244;
  v2(21,3)=  v2(20,3);
  v2(22,1)=2;
  v2(22,2)=177;
  v2(22,3)=(-(params(2)*params(1)*y(14)*T173));
  v2(23,1)=2;
  v2(23,2)=262;
  v2(23,3)=  v2(22,3);
  v2(24,1)=2;
  v2(24,2)=184;
  v2(24,3)=(-((-y(12))/(y(4)*y(4))*T143*T212));
  v2(25,1)=2;
  v2(25,2)=65;
  v2(25,3)=  v2(24,3);
  v2(26,1)=2;
  v2(26,2)=191;
  v2(26,3)=(-(T76*XSS__*PSI__*getPowerDeriv(y(11),params(5),2)));
  v2(27,1)=2;
  v2(27,2)=202;
  v2(27,3)=(-(T72*(T147*T252+T143*(-1)/(y(4)*y(4)))));
  v2(28,1)=2;
  v2(28,2)=66;
  v2(28,3)=  v2(27,3);
  v2(29,1)=2;
  v2(29,2)=209;
  v2(29,3)=(-(T212*T143*T147));
  v2(30,1)=2;
  v2(30,2)=192;
  v2(30,3)=  v2(29,3);
  v2(31,1)=2;
  v2(31,2)=210;
  v2(31,3)=(-(T72*T147*T147*T251));
  v2(32,1)=3;
  v2(32,2)=77;
  v2(32,3)=(-((-((-y(12))*(y(5)+y(5))))/(y(5)*y(5)*y(5)*y(5))));
  v2(33,1)=3;
  v2(33,2)=266;
  v2(33,3)=(-(params(2)*params(1)*y(10)*T178));
  v2(34,1)=3;
  v2(34,2)=249;
  v2(34,3)=  v2(33,3);
  v2(35,1)=3;
  v2(35,2)=267;
  v2(35,3)=(-(params(2)*params(1)*y(10)*y(14)*getPowerDeriv(y(15),params(4)-1,2)/y(16)));
  v2(36,1)=3;
  v2(36,2)=132;
  v2(36,3)=(-1)/(y(8)*y(8));
  v2(37,1)=3;
  v2(37,2)=98;
  v2(37,3)=  v2(36,3);
  v2(38,1)=3;
  v2(38,2)=134;
  v2(38,3)=(-((-y(6))*(y(8)+y(8))))/(y(8)*y(8)*y(8)*y(8));
  v2(39,1)=3;
  v2(39,2)=284;
  v2(39,3)=(-(params(2)*params(1)*y(10)*(-T89)/(y(16)*y(16))));
  v2(40,1)=3;
  v2(40,2)=250;
  v2(40,3)=  v2(39,3);
  v2(41,1)=3;
  v2(41,2)=285;
  v2(41,3)=(-(params(2)*params(1)*y(10)*y(14)*(-T177)/(y(16)*y(16))));
  v2(42,1)=3;
  v2(42,2)=268;
  v2(42,3)=  v2(41,3);
  v2(43,1)=3;
  v2(43,2)=286;
  v2(43,3)=(-(params(2)*params(1)*y(10)*y(14)*(-((-T89)*(y(16)+y(16))))/(y(16)*y(16)*y(16)*y(16))));
  v2(44,1)=3;
  v2(44,2)=176;
  v2(44,3)=(-(params(2)*params(1)*T91));
  v2(45,1)=3;
  v2(45,2)=244;
  v2(45,3)=  v2(44,3);
  v2(46,1)=3;
  v2(46,2)=177;
  v2(46,3)=(-(params(2)*params(1)*y(14)*T178));
  v2(47,1)=3;
  v2(47,2)=262;
  v2(47,3)=  v2(46,3);
  v2(48,1)=3;
  v2(48,2)=178;
  v2(48,3)=(-(params(2)*params(1)*y(14)*(-T89)/(y(16)*y(16))));
  v2(49,1)=3;
  v2(49,2)=280;
  v2(49,3)=  v2(48,3);
  v2(50,1)=3;
  v2(50,2)=203;
  v2(50,3)=(-((-1)/(y(5)*y(5))));
  v2(51,1)=3;
  v2(51,2)=84;
  v2(51,3)=  v2(50,3);
  v2(52,1)=5;
  v2(52,2)=115;
  v2(52,3)=(-(params(2)*getPowerDeriv(y(7),params(4)-1,2)));
  v2(53,1)=5;
  v2(53,2)=134;
  v2(53,3)=(-((1-params(2))*getPowerDeriv(y(8),1-params(4),2)));
  v2(54,1)=6;
  v2(54,2)=115;
  v2(54,3)=(-(y(3)*params(2)*getPowerDeriv(y(7),params(4),2)));
  v2(55,1)=6;
  v2(55,2)=134;
  v2(55,3)=(-((1-params(2))*getPowerDeriv(y(8),(-params(4)),2)));
  v2(56,1)=6;
  v2(56,2)=43;
  v2(56,3)=(-T165);
  v2(57,1)=6;
  v2(57,2)=111;
  v2(57,3)=  v2(56,3);
  v2(58,1)=8;
  v2(58,2)=20;
  v2(58,3)=(-(params(12)*(-1)/(y(2)*y(2))));
  v2(59,1)=8;
  v2(59,2)=172;
  v2(59,3)=(-1)/(y(10)*y(10));
  v2(60,1)=9;
  v2(60,2)=1;
  v2(60,3)=(-(params(11)*(-1)/(y(1)*y(1))));
  v2(61,1)=9;
  v2(61,2)=58;
  v2(61,3)=(-1)/(y(4)*y(4));
  g2 = sparse(v2(:,1),v2(:,2),v2(:,3),9,324);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],9,5832);
end
end
end
end
