var pi ihat rhat yhat nhat chat what dhat tauhat mchat;
parameters beta varphi theta_p phi_pi rho_v epsilon_p lambda_p lambda_w rho Sbar taubar rho_tau alpha;
varexo e;

load parameters.mat
alpha=alpha_val;
beta=beta_val;
varphi=varphi_val;
theta_p=theta_p_val;
phi_pi=phi_pi_val;
epsilon_p=epsilon_p_val;
rho=-log(beta);
rho_v=rho_v_val;
Sbar = Sbar_val;
rho_tau = rho_tau_val;
taubar = taubar_val;

lambda_p = (1-theta_p)*(1-beta*theta_p)/theta_p*(alpha)/(alpha+(1-alpha)*epsilon_p);

model(linear);
%fiscal shock
tauhat=rho_tau*tauhat(-1)+e;

%Goods market clearing
(1-taubar)*chat + taubar*tauhat = yhat;

%Bond market clearing
(1-taubar)*chat + taubar*tauhat = Sbar * (what + nhat) + (1-Sbar) * dhat;

%Euler equation
chat = -(ihat-pi(+1))+chat(+1);

%Goods price Phillips
pi = beta*pi(+1)+lambda_p*mchat;

%Labor supply
what = varphi*nhat + chat;

%Production function
yhat = alpha*nhat;

% marginal cost
mchat = what+(1/alpha-1)*yhat;

%Policy
ihat = phi_pi*pi;

%Real interest rate
rhat=ihat-pi(+1);
end;

shocks;
var e = 1;
end;

stoch_simul(order=1, nograph);